/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.util.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class OpenOnWriteFileOutputStream
extends OutputStream {
    private final File file;
    private OutputStream out;

    public OpenOnWriteFileOutputStream(File file) {
        this.file = file;
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            this.out = new FileOutputStream(this.file);
        }
    }

    @Override
    public void close() throws IOException {
        this.ensureOpen();
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        this.out.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureOpen();
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.ensureOpen();
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        this.out.write(b, off, len);
    }
}

