/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.dependencies;

import com.mycila.maven.plugin.license.dependencies.LicenseMap;
import com.mycila.maven.plugin.license.dependencies.LicenseMessage;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.License;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.DefaultProjectBuilder;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;

public class MavenProjectLicenses
implements LicenseMap,
LicenseMessage {
    private MavenSession session;
    private Set<MavenProject> projects;
    private DependencyGraphBuilder graph;
    private ProjectBuilder projectBuilder;
    private ArtifactFilter filter;
    private Log log;

    MavenProjectLicenses(MavenSession session, Set<MavenProject> projects, DependencyGraphBuilder graph, ProjectBuilder projectBuilder, ArtifactFilter filter, Log log) {
        this.setSession(session);
        this.setProjects(projects);
        this.setGraph(graph);
        this.setFilter(filter);
        this.setProjectBuilder(projectBuilder);
        this.setLog(log);
        log.info((CharSequence)String.format("%s %s", "Checking licenses in dependencies using", this.getClass()));
    }

    public MavenProjectLicenses(MavenSession session, MavenProject project, DependencyGraphBuilder graph, ProjectBuilder projectBuilder, List<String> scopes, Log log) {
        this(session, Collections.singleton(project), graph, projectBuilder, (ArtifactFilter)new CumulativeScopeArtifactFilter(scopes), log);
    }

    protected Set<License> getLicensesFromArtifact(Artifact artifact) {
        HashSet<License> licenses;
        block2: {
            licenses = new HashSet<License>();
            try {
                MavenProject project = this.getProjectBuilder().build(artifact, this.getBuildingRequest()).getProject();
                licenses.addAll(project.getLicenses());
            }
            catch (ProjectBuildingException ex) {
                if (!this.getLog().isWarnEnabled()) break block2;
                this.getLog().warn((CharSequence)String.format("Could not get project from dependency's artifact: %s", artifact.getFile()));
            }
        }
        return licenses;
    }

    protected Map<License, Set<Artifact>> getLicenseMapFromArtifacts(Set<Artifact> dependencies) {
        ConcurrentHashMap<License, Set<Artifact>> map = new ConcurrentHashMap<License, Set<Artifact>>();
        dependencies.parallelStream().forEach(artifact -> this.getLicensesFromArtifact((Artifact)artifact).forEach(license -> {
            map.putIfAbsent((License)license, new HashSet());
            Set artifacts = (Set)map.get(license);
            artifacts.add(artifact);
            map.put((License)license, artifacts);
        }));
        return map;
    }

    @Override
    public Map<License, Set<Artifact>> getLicenseMap() {
        return this.getLicenseMapFromArtifacts(this.getDependencies());
    }

    private Set<Artifact> getDependencies() {
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        HashSet dependencies = new HashSet();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format("Building dependency graphs for %d projects", this.getProjects().size()));
        }
        this.getProjects().parallelStream().forEach(project -> {
            block2: {
                try {
                    DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.getBuildingRequest());
                    buildingRequest.setProject(project);
                    dependencies.addAll(this.getGraph().buildDependencyGraph((ProjectBuildingRequest)buildingRequest, this.getFilter()).getChildren());
                }
                catch (DependencyGraphBuilderException ex) {
                    if (!this.getLog().isWarnEnabled()) break block2;
                    this.getLog().warn((CharSequence)String.format("Could not get children from project %s, it's dependencies will not be checked!", project.getId()));
                }
            }
        });
        dependencies.parallelStream().forEach(d -> artifacts.add(d.getArtifact()));
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)String.format("%s: %d", "Discovered dependencies after filtering", dependencies.size()));
        }
        return artifacts;
    }

    protected Set<MavenProject> getProjects() {
        return this.projects;
    }

    private void setSession(MavenSession session) {
        this.session = session;
    }

    protected void setProjects(Set<MavenProject> projects) {
        this.projects = Optional.ofNullable(projects).orElse(new HashSet());
    }

    private DependencyGraphBuilder getGraph() {
        return this.graph;
    }

    private void setGraph(DependencyGraphBuilder graph) {
        this.graph = graph;
    }

    private ProjectBuilder getProjectBuilder() {
        return this.projectBuilder;
    }

    private void setProjectBuilder(ProjectBuilder projectBuilder) {
        this.projectBuilder = Optional.ofNullable(projectBuilder).orElse((ProjectBuilder)new DefaultProjectBuilder());
    }

    private ArtifactFilter getFilter() {
        return this.filter;
    }

    private void setFilter(ArtifactFilter filter) {
        this.filter = filter;
    }

    private Log getLog() {
        return this.log;
    }

    private void setLog(Log log) {
        this.log = log;
    }

    private ProjectBuildingRequest getBuildingRequest() {
        return this.session.getProjectBuildingRequest();
    }
}

