/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.console.endpoint;

import com.nepxion.discovery.common.entity.InstanceEntity;
import com.nepxion.discovery.common.entity.InstanceEntityWrapper;
import com.nepxion.discovery.common.entity.UserEntity;
import com.nepxion.discovery.common.handler.RestErrorHandler;
import com.nepxion.discovery.console.adapter.ConfigAdapter;
import com.nepxion.discovery.console.authentication.AuthenticationResource;
import com.nepxion.discovery.console.rest.ConfigClearRestInvoker;
import com.nepxion.discovery.console.rest.ConfigUpdateRestInvoker;
import com.nepxion.discovery.console.rest.SentinelClearRestInvoker;
import com.nepxion.discovery.console.rest.SentinelUpdateRestInvoker;
import com.nepxion.discovery.console.rest.VersionClearRestInvoker;
import com.nepxion.discovery.console.rest.VersionUpdateRestInvoker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.composite.CompositeDiscoveryClient;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(path={"/console"})
@Api(tags={"\u63a7\u5236\u53f0\u63a5\u53e3"})
public class ConsoleEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(ConsoleEndpoint.class);
    private static final String[] DISCOVERY_TYPES = new String[]{"Eureka", "Consul", "Zookeeper", "Nacos"};
    @Autowired
    private DiscoveryClient discoveryClient;
    @Autowired(required=false)
    private ConfigAdapter configAdapter;
    @Autowired
    private AuthenticationResource authenticationResource;
    private RestTemplate consoleRestTemplate = new RestTemplate();

    public ConsoleEndpoint() {
        this.consoleRestTemplate.setErrorHandler((ResponseErrorHandler)new RestErrorHandler());
    }

    @RequestMapping(path={"/authenticate"}, method={RequestMethod.POST})
    @ApiOperation(value="\u767b\u5f55\u8ba4\u8bc1", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> authenticate(@RequestBody @ApiParam(value="UserEntity\u5b9e\u4f8b", required=true) UserEntity userEntity) {
        return this.executeAuthenticate(userEntity);
    }

    @RequestMapping(path={"/discovery-type"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u6ce8\u518c\u53d1\u73b0\u4e2d\u5fc3\u7c7b\u578b", notes="", response=ResponseEntity.class, httpMethod="GET")
    @ResponseBody
    public ResponseEntity<?> discoveryType() {
        return this.getDiscoveryType();
    }

    @RequestMapping(path={"/config-type"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u914d\u7f6e\u4e2d\u5fc3\u7c7b\u578b", notes="", response=ResponseEntity.class, httpMethod="GET")
    @ResponseBody
    public ResponseEntity<?> configType() {
        return this.getConfigType();
    }

    @RequestMapping(path={"/groups"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u6ce8\u518c\u4e2d\u5fc3\u7684\u670d\u52a1\u7ec4\u540d\u5217\u8868", notes="", response=List.class, httpMethod="GET")
    @ResponseBody
    public List<String> groups() {
        return this.getGroups();
    }

    @RequestMapping(path={"/services"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u6ce8\u518c\u4e2d\u5fc3\u7684\u670d\u52a1\u540d\u5217\u8868", notes="", response=List.class, httpMethod="GET")
    @ResponseBody
    public List<String> services() {
        return this.getServices();
    }

    @RequestMapping(path={"/instances/{serviceId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u6ce8\u518c\u4e2d\u5fc3\u7684\u670d\u52a1\u5b9e\u4f8b\u5217\u8868", notes="", response=List.class, httpMethod="GET")
    @ResponseBody
    public List<ServiceInstance> instances(@PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d", required=true) String serviceId) {
        return this.getInstances(serviceId);
    }

    @RequestMapping(path={"/instance-list/{serviceId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u6ce8\u518c\u4e2d\u5fc3\u7684\u670d\u52a1\u5b9e\u4f8b\u5217\u8868\uff08\u7cbe\u7b80\u6570\u636e\uff09", notes="", response=List.class, httpMethod="GET")
    @ResponseBody
    public List<InstanceEntity> instanceList(@PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d", required=true) String serviceId) {
        return this.getInstanceList(serviceId);
    }

    @RequestMapping(path={"/instance-map"}, method={RequestMethod.POST})
    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u6ce8\u518c\u4e2d\u5fc3\u7684\u670d\u52a1\u5b9e\u4f8b\u7684Map\uff08\u7cbe\u7b80\u6570\u636e\uff09", notes="\u670d\u52a1\u7ec4\u540d\u5217\u8868", response=Map.class, httpMethod="POST")
    @ResponseBody
    public Map<String, List<InstanceEntity>> instanceMap(@RequestBody @ApiParam(value="\u670d\u52a1\u7ec4\u540d\u5217\u8868\uff0c\u4f20\u5165\u7a7a\u5217\u5219\u53ef\u4ee5\u83b7\u53d6\u5168\u90e8\u670d\u52a1\u5b9e\u4f8b\u6570\u636e", required=true) List<String> groups) {
        return this.getInstanceMap(groups);
    }

    @RequestMapping(path={"/remote-config/update/{group}/{serviceId}"}, method={RequestMethod.POST})
    @ApiOperation(value="\u63a8\u9001\u66f4\u65b0\u89c4\u5219\u914d\u7f6e\u4fe1\u606f\u5230\u8fdc\u7a0b\u914d\u7f6e\u4e2d\u5fc3", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> remoteConfigUpdate(@PathVariable(value="group") @ApiParam(value="\u7ec4\u540d", required=true) String group, @PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d\u3002\u5f53\u5168\u5c40\u63a8\u9001\u6a21\u5f0f\u4e0b\uff0c\u670d\u52a1\u540d\u5fc5\u987b\u7531\u7ec4\u540d\u6765\u4ee3\u66ff", required=true) String serviceId, @RequestBody @ApiParam(value="\u89c4\u5219\u914d\u7f6e\u5185\u5bb9\uff0cXML\u683c\u5f0f", required=true) String config) {
        return this.executeRemoteConfigUpdate(group, serviceId, config);
    }

    @RequestMapping(path={"/remote-config/clear/{group}/{serviceId}"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6e05\u9664\u89c4\u5219\u914d\u7f6e\u4fe1\u606f\u5230\u8fdc\u7a0b\u914d\u7f6e\u4e2d\u5fc3", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> remoteConfigClear(@PathVariable(value="group") @ApiParam(value="\u7ec4\u540d", required=true) String group, @PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d\u3002\u5f53\u5168\u5c40\u63a8\u9001\u6a21\u5f0f\u4e0b\uff0c\u670d\u52a1\u540d\u5fc5\u987b\u7531\u7ec4\u540d\u6765\u4ee3\u66ff", required=true) String serviceId) {
        return this.executeRemoteConfigClear(group, serviceId);
    }

    @RequestMapping(path={"/remote-config/view/{group}/{serviceId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u67e5\u770b\u8fdc\u7a0b\u914d\u7f6e\u4e2d\u5fc3\u7684\u89c4\u5219\u914d\u7f6e\u4fe1\u606f", notes="", response=ResponseEntity.class, httpMethod="GET")
    @ResponseBody
    public ResponseEntity<?> remoteConfigView(@PathVariable(value="group") @ApiParam(value="\u7ec4\u540d", required=true) String group, @PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d\u3002\u5f53\u5168\u5c40\u63a8\u9001\u6a21\u5f0f\u4e0b\uff0c\u670d\u52a1\u540d\u5fc5\u987b\u7531\u7ec4\u540d\u6765\u4ee3\u66ff", required=true) String serviceId) {
        return this.executeRemoteConfigView(group, serviceId);
    }

    @RequestMapping(path={"/config/update-async/{serviceId}"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6279\u91cf\u5f02\u6b65\u63a8\u9001\u66f4\u65b0\u89c4\u5219\u914d\u7f6e\u4fe1\u606f", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> configUpdateAsync(@PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d", required=true) String serviceId, @RequestBody @ApiParam(value="\u89c4\u5219\u914d\u7f6e\u5185\u5bb9\uff0cXML\u683c\u5f0f", required=true) String config) {
        return this.executeConfigUpdate(serviceId, config, true);
    }

    @RequestMapping(path={"/config/update-sync/{serviceId}"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6279\u91cf\u540c\u6b65\u63a8\u9001\u66f4\u65b0\u89c4\u5219\u914d\u7f6e\u4fe1\u606f", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> configUpdateSync(@PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d", required=true) String serviceId, @RequestBody @ApiParam(value="\u89c4\u5219\u914d\u7f6e\u5185\u5bb9\uff0cXML\u683c\u5f0f", required=true) String config) {
        return this.executeConfigUpdate(serviceId, config, false);
    }

    @RequestMapping(path={"/config/clear-async/{serviceId}"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6279\u91cf\u5f02\u6b65\u6e05\u9664\u66f4\u65b0\u7684\u89c4\u5219\u914d\u7f6e\u4fe1\u606f", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> configClearAsync(@PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d", required=true) String serviceId) {
        return this.executeConfigClear(serviceId, true);
    }

    @RequestMapping(path={"/config/clear-sync/{serviceId}"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6279\u91cf\u540c\u6b65\u6e05\u9664\u66f4\u65b0\u7684\u89c4\u5219\u914d\u7f6e\u4fe1\u606f", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> configClearSync(@PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d", required=true) String serviceId) {
        return this.executeConfigClear(serviceId, false);
    }

    @RequestMapping(path={"/version/update-async/{serviceId}"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6279\u91cf\u5f02\u6b65\u66f4\u65b0\u670d\u52a1\u7684\u52a8\u6001\u7248\u672c", notes="\u6839\u636e\u6307\u5b9a\u7684localVersion\u66f4\u65b0\u670d\u52a1\u7684dynamicVersion\u3002\u5982\u679c\u8f93\u5165\u7684localVersion\u4e0d\u5339\u914d\u670d\u52a1\u7684localVersion\uff0c\u5219\u5ffd\u7565\uff1b\u5982\u679c\u5982\u679c\u8f93\u5165\u7684localVersion\u4e3a\u7a7a\uff0c\u5219\u76f4\u63a5\u66f4\u65b0\u670d\u52a1\u7684dynamicVersion", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> versionUpdateAsync(@PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d", required=true) String serviceId, @RequestBody @ApiParam(value="\u7248\u672c\u53f7\uff0c\u683c\u5f0f\u4e3a[dynamicVersion]\u6216\u8005[dynamicVersion];[localVersion]", required=true) String version) {
        return this.executeVersionUpdate(serviceId, version, true);
    }

    @RequestMapping(path={"/version/update-sync/{serviceId}"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6279\u91cf\u540c\u6b65\u66f4\u65b0\u670d\u52a1\u7684\u52a8\u6001\u7248\u672c", notes="\u6839\u636e\u6307\u5b9a\u7684localVersion\u66f4\u65b0\u670d\u52a1\u7684dynamicVersion\u3002\u5982\u679c\u8f93\u5165\u7684localVersion\u4e0d\u5339\u914d\u670d\u52a1\u7684localVersion\uff0c\u5219\u5ffd\u7565\uff1b\u5982\u679c\u5982\u679c\u8f93\u5165\u7684localVersion\u4e3a\u7a7a\uff0c\u5219\u76f4\u63a5\u66f4\u65b0\u670d\u52a1\u7684dynamicVersion", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> versionUpdateSync(@PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d", required=true) String serviceId, @RequestBody @ApiParam(value="\u7248\u672c\u53f7\uff0c\u683c\u5f0f\u4e3a[dynamicVersion]\u6216\u8005[dynamicVersion];[localVersion]", required=true) String version) {
        return this.executeVersionUpdate(serviceId, version, false);
    }

    @RequestMapping(path={"/version/clear-async/{serviceId}"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6279\u91cf\u5f02\u6b65\u6e05\u9664\u670d\u52a1\u7684\u52a8\u6001\u7248\u672c", notes="\u6839\u636e\u6307\u5b9a\u7684localVersion\u6e05\u9664\u670d\u52a1\u7684dynamicVersion\u3002\u5982\u679c\u8f93\u5165\u7684localVersion\u4e0d\u5339\u914d\u670d\u52a1\u7684localVersion\uff0c\u5219\u5ffd\u7565\uff1b\u5982\u679c\u5982\u679c\u8f93\u5165\u7684localVersion\u4e3a\u7a7a\uff0c\u5219\u76f4\u63a5\u6e05\u9664\u670d\u52a1\u7684dynamicVersion", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> versionClearAsync(@PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d", required=true) String serviceId, @RequestBody(required=false) @ApiParam(value="\u7248\u672c\u53f7\uff0c\u6307localVersion\uff0c\u53ef\u4ee5\u4e3a\u7a7a") String version) {
        return this.executeVersionClear(serviceId, version, true);
    }

    @RequestMapping(path={"/version/clear-sync/{serviceId}"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6279\u91cf\u540c\u6b65\u6e05\u9664\u670d\u52a1\u7684\u52a8\u6001\u7248\u672c", notes="\u6839\u636e\u6307\u5b9a\u7684localVersion\u6e05\u9664\u670d\u52a1\u7684dynamicVersion\u3002\u5982\u679c\u8f93\u5165\u7684localVersion\u4e0d\u5339\u914d\u670d\u52a1\u7684localVersion\uff0c\u5219\u5ffd\u7565\uff1b\u5982\u679c\u5982\u679c\u8f93\u5165\u7684localVersion\u4e3a\u7a7a\uff0c\u5219\u76f4\u63a5\u6e05\u9664\u670d\u52a1\u7684dynamicVersion", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> versionClearSync(@PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d", required=true) String serviceId, @RequestBody(required=false) @ApiParam(value="\u7248\u672c\u53f7\uff0c\u6307localVersion\uff0c\u53ef\u4ee5\u4e3a\u7a7a") String version) {
        return this.executeVersionClear(serviceId, version, false);
    }

    @RequestMapping(path={"/sentinel/update/{serviceId}/{ruleType}"}, method={RequestMethod.POST})
    @ApiOperation(value="\u66f4\u65b0\u54e8\u5175\u89c4\u5219\u5217\u8868", notes="\u54e8\u5175\u89c4\u5219\u7c7b\u578b\u53d6\u503c\uff1a flow | degrade | authority | system | param-flow", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> sentinelUpdate(@PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d", required=true) String serviceId, @PathVariable(value="ruleType") @ApiParam(value="\u54e8\u5175\u89c4\u5219\u7c7b\u578b", required=true) String ruleType, @RequestBody @ApiParam(value="\u54e8\u5175\u89c4\u5219\u5185\u5bb9\uff0cJSON\u683c\u5f0f", required=true) String rule) {
        return this.executeSentinelUpdate(serviceId, ruleType, rule);
    }

    @RequestMapping(path={"/sentinel/clear/{serviceId}/{ruleType}"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6e05\u9664\u54e8\u5175\u89c4\u5219\u5217\u8868", notes="\u54e8\u5175\u89c4\u5219\u7c7b\u578b\u53d6\u503c\uff1a flow | degrade | authority | system | param-flow", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> sentinelClear(@PathVariable(value="serviceId") @ApiParam(value="\u670d\u52a1\u540d", required=true) String serviceId, @PathVariable(value="ruleType") @ApiParam(value="\u54e8\u5175\u89c4\u5219\u7c7b\u578b", required=true) String ruleType) {
        return this.executeSentinelClear(serviceId, ruleType);
    }

    private ResponseEntity<?> executeAuthenticate(UserEntity userEntity) {
        try {
            boolean result = this.authenticationResource.authenticate(userEntity);
            return ResponseEntity.ok().body((Object)result);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getMessage());
        }
    }

    private ResponseEntity<?> getDiscoveryType() {
        if (this.discoveryClient instanceof CompositeDiscoveryClient) {
            CompositeDiscoveryClient compositeDiscoveryClient = (CompositeDiscoveryClient)this.discoveryClient;
            List discoveryClients = compositeDiscoveryClient.getDiscoveryClients();
            for (DiscoveryClient client : discoveryClients) {
                String discoveryDescription = client.description();
                for (int i = 0; i < DISCOVERY_TYPES.length; ++i) {
                    String discoveryType = DISCOVERY_TYPES[i];
                    if (!discoveryDescription.toLowerCase().contains(discoveryType.toLowerCase())) continue;
                    return ResponseEntity.ok().body((Object)discoveryType);
                }
            }
        } else {
            String discoveryDescription = this.discoveryClient.description();
            for (int i = 0; i < DISCOVERY_TYPES.length; ++i) {
                String discoveryType = DISCOVERY_TYPES[i];
                if (!discoveryDescription.toLowerCase().contains(discoveryType.toLowerCase())) continue;
                return ResponseEntity.ok().body((Object)discoveryType);
            }
        }
        return ResponseEntity.ok().body((Object)"unknown");
    }

    private ResponseEntity<?> getConfigType() {
        if (this.configAdapter != null) {
            String configType = this.configAdapter.getConfigType();
            return ResponseEntity.ok().body((Object)configType);
        }
        return ResponseEntity.ok().body((Object)"unknown");
    }

    public List<String> getGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        List<String> services = this.getServices();
        for (String service : services) {
            List<InstanceEntity> instanceEntityList = this.getInstanceList(service);
            for (InstanceEntity instance : instanceEntityList) {
                String plugin = InstanceEntityWrapper.getPlugin((InstanceEntity)instance);
                String group = InstanceEntityWrapper.getGroup((InstanceEntity)instance);
                if (!StringUtils.isNotEmpty((CharSequence)plugin) || groups.contains(group)) continue;
                groups.add(group);
            }
        }
        return groups;
    }

    public List<String> getServices() {
        return this.discoveryClient.getServices();
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        return this.discoveryClient.getInstances(serviceId);
    }

    public List<InstanceEntity> getInstanceList(String service) {
        List<ServiceInstance> serviceInstances = this.getInstances(service);
        ArrayList<InstanceEntity> instanceEntityList = new ArrayList<InstanceEntity>(serviceInstances.size());
        for (ServiceInstance serviceInstance : serviceInstances) {
            Map metadata = serviceInstance.getMetadata();
            String serviceId = serviceInstance.getServiceId().toLowerCase();
            String serviceType = (String)metadata.get("spring.application.type");
            String version = (String)metadata.get("version");
            String region = (String)metadata.get("region");
            String environment = (String)metadata.get("env");
            String host = serviceInstance.getHost();
            int port = serviceInstance.getPort();
            InstanceEntity instanceEntity = new InstanceEntity();
            instanceEntity.setServiceType(serviceType);
            instanceEntity.setServiceId(serviceId);
            instanceEntity.setVersion(version);
            instanceEntity.setRegion(region);
            instanceEntity.setEnvironment(environment);
            instanceEntity.setHost(host);
            instanceEntity.setPort(port);
            instanceEntity.setMetadata(metadata);
            instanceEntityList.add(instanceEntity);
        }
        return instanceEntityList;
    }

    public Map<String, List<InstanceEntity>> getInstanceMap(List<String> groups) {
        List<String> services = this.getServices();
        LinkedHashMap<String, List<InstanceEntity>> instanceMap = new LinkedHashMap<String, List<InstanceEntity>>(services.size());
        for (String service : services) {
            List<InstanceEntity> instanceEntityList = this.getInstanceList(service);
            if (CollectionUtils.isNotEmpty(groups)) {
                for (InstanceEntity instance : instanceEntityList) {
                    String plugin = InstanceEntityWrapper.getPlugin((InstanceEntity)instance);
                    String group = InstanceEntityWrapper.getGroup((InstanceEntity)instance);
                    if (!StringUtils.isNotEmpty((CharSequence)plugin) || !groups.contains(group)) continue;
                    ArrayList<InstanceEntity> instanceList = (ArrayList<InstanceEntity>)instanceMap.get(service);
                    if (instanceList == null) {
                        instanceList = new ArrayList<InstanceEntity>();
                        instanceMap.put(service, instanceList);
                    }
                    instanceList.add(instance);
                }
                continue;
            }
            instanceMap.put(service, instanceEntityList);
        }
        return instanceMap;
    }

    private ResponseEntity<?> executeRemoteConfigUpdate(String group, String serviceId, String config) {
        if (this.configAdapter == null) {
            LOG.error("Remote config adapter isn't provided");
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Remote config adapter isn't provided");
        }
        try {
            boolean result = this.configAdapter.updateConfig(group, serviceId, config);
            return ResponseEntity.ok().body((Object)(result ? "OK" : "NO"));
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getMessage());
        }
    }

    private ResponseEntity<?> executeRemoteConfigClear(String group, String serviceId) {
        if (this.configAdapter == null) {
            LOG.error("Remote config adapter isn't provided");
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Remote config adapter isn't provided");
        }
        try {
            boolean result = this.configAdapter.clearConfig(group, serviceId);
            return ResponseEntity.ok().body((Object)(result ? "OK" : "NO"));
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getMessage());
        }
    }

    private ResponseEntity<?> executeRemoteConfigView(String group, String serviceId) {
        if (this.configAdapter == null) {
            LOG.error("Remote config adapter isn't provided");
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Remote config adapter isn't provided");
        }
        try {
            String config = this.configAdapter.getConfig(group, serviceId);
            return ResponseEntity.ok().body((Object)config);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getMessage());
        }
    }

    private ResponseEntity<?> executeConfigUpdate(String serviceId, String config, boolean async) {
        List<ServiceInstance> serviceInstances = this.getInstances(serviceId);
        ConfigUpdateRestInvoker configUpdateRestInvoker = new ConfigUpdateRestInvoker(serviceInstances, this.consoleRestTemplate, config, async);
        return configUpdateRestInvoker.invoke();
    }

    private ResponseEntity<?> executeConfigClear(String serviceId, boolean async) {
        List<ServiceInstance> serviceInstances = this.getInstances(serviceId);
        ConfigClearRestInvoker configClearRestInvoker = new ConfigClearRestInvoker(serviceInstances, this.consoleRestTemplate, async);
        return configClearRestInvoker.invoke();
    }

    private ResponseEntity<?> executeVersionUpdate(String serviceId, String version, boolean async) {
        List<ServiceInstance> serviceInstances = this.getInstances(serviceId);
        VersionUpdateRestInvoker versionUpdateRestInvoker = new VersionUpdateRestInvoker(serviceInstances, this.consoleRestTemplate, version, async);
        return versionUpdateRestInvoker.invoke();
    }

    private ResponseEntity<?> executeVersionClear(String serviceId, String version, boolean async) {
        List<ServiceInstance> serviceInstances = this.getInstances(serviceId);
        VersionClearRestInvoker versionClearRestInvoker = new VersionClearRestInvoker(serviceInstances, this.consoleRestTemplate, version, async);
        return versionClearRestInvoker.invoke();
    }

    private ResponseEntity<?> executeSentinelUpdate(String serviceId, String ruleType, String rule) {
        List<ServiceInstance> serviceInstances = this.getInstances(serviceId);
        SentinelUpdateRestInvoker sentinelUpdateRestInvoker = new SentinelUpdateRestInvoker(serviceInstances, this.consoleRestTemplate, ruleType, rule);
        return sentinelUpdateRestInvoker.invoke();
    }

    private ResponseEntity<?> executeSentinelClear(String serviceId, String ruleType) {
        List<ServiceInstance> serviceInstances = this.getInstances(serviceId);
        SentinelClearRestInvoker sentinelClearRestInvoker = new SentinelClearRestInvoker(serviceInstances, this.consoleRestTemplate, ruleType);
        return sentinelClearRestInvoker.invoke();
    }
}

