/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.configcenter.configuration;

import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.plugin.configcenter.context.ConfigContextClosedHandler;
import com.nepxion.discovery.plugin.configcenter.initializer.ConfigInitializer;
import com.nepxion.discovery.plugin.configcenter.loader.LocalConfigLoader;
import com.nepxion.discovery.plugin.configcenter.parser.json.JsonConfigParser;
import com.nepxion.discovery.plugin.configcenter.parser.xml.XmlConfigParser;
import com.nepxion.discovery.plugin.framework.config.PluginConfigParser;
import com.nepxion.discovery.plugin.framework.context.PluginContextAware;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ConfigAutoConfiguration {
    @Autowired
    private PluginContextAware pluginContextAware;

    @Bean
    public PluginConfigParser pluginConfigParser() {
        String configFormat = this.pluginContextAware.getConfigFormat();
        if (StringUtils.equals((CharSequence)configFormat, (CharSequence)"xml")) {
            return new XmlConfigParser();
        }
        if (StringUtils.equals((CharSequence)configFormat, (CharSequence)"json")) {
            return new JsonConfigParser();
        }
        throw new DiscoveryException("Invalid config format for '" + configFormat + "'");
    }

    @Bean
    public LocalConfigLoader localConfigLoader() {
        return new LocalConfigLoader(){

            @Override
            protected String getPath() {
                return ConfigAutoConfiguration.this.pluginContextAware.getConfigPath();
            }
        };
    }

    @Bean
    public ConfigInitializer configInitializer() {
        return new ConfigInitializer();
    }

    @Bean
    public ConfigContextClosedHandler configContextClosedHandler() {
        return new ConfigContextClosedHandler();
    }
}

