/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.configcenter.initializer;

import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.plugin.configcenter.loader.LocalConfigLoader;
import com.nepxion.discovery.plugin.configcenter.loader.RemoteConfigLoader;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.config.PluginConfigParser;
import com.nepxion.discovery.plugin.framework.context.PluginContextAware;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ConfigInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigInitializer.class);
    @Autowired
    private PluginContextAware pluginContextAware;
    @Autowired
    private PluginAdapter pluginAdapter;
    @Autowired
    private PluginConfigParser pluginConfigParser;
    @Autowired
    private LocalConfigLoader localConfigLoader;
    @Autowired(required=false)
    private RemoteConfigLoader remoteConfigLoader;

    @PostConstruct
    public void initialize() {
        String localConfig;
        Boolean registerControlEnabled = this.pluginContextAware.isRegisterControlEnabled();
        Boolean discoveryControlEnabled = this.pluginContextAware.isDiscoveryControlEnabled();
        if (!registerControlEnabled.booleanValue() && !discoveryControlEnabled.booleanValue()) {
            LOG.info("Register and Discovery controls are all disabled, ignore to initialize");
            return;
        }
        LOG.info("------------- Load Discovery Config --------------");
        String remoteConfig = this.getRemoteConfig();
        if (StringUtils.isNotEmpty((CharSequence)remoteConfig)) {
            try {
                RuleEntity ruleEntity = this.pluginConfigParser.parse(remoteConfig);
                this.pluginAdapter.setDynamicRule(ruleEntity);
            }
            catch (Exception e) {
                LOG.error("Parse config failed", (Throwable)e);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(localConfig = this.getLocalConfig()))) {
            try {
                RuleEntity ruleEntity = this.pluginConfigParser.parse(localConfig);
                this.pluginAdapter.setLocalRule(ruleEntity);
            }
            catch (Exception e) {
                LOG.error("Parse config failed", (Throwable)e);
            }
        }
        if (StringUtils.isEmpty((CharSequence)remoteConfig) && StringUtils.isEmpty((CharSequence)localConfig)) {
            LOG.info("No config is found");
        }
        LOG.info("--------------------------------------------------");
    }

    private String getRemoteConfig() {
        if (this.remoteConfigLoader != null) {
            String config = null;
            try {
                config = this.remoteConfigLoader.getConfig();
            }
            catch (Exception e) {
                LOG.warn("Get remote config failed", (Throwable)e);
            }
            if (StringUtils.isNotEmpty((CharSequence)config)) {
                return config;
            }
        } else {
            LOG.info("Remote config loader isn't provided");
        }
        return null;
    }

    private String getLocalConfig() {
        String config = null;
        try {
            config = this.localConfigLoader.getConfig();
        }
        catch (Exception e) {
            LOG.warn("Get local config failed", (Throwable)e);
        }
        if (StringUtils.isNotEmpty((CharSequence)config)) {
            return config;
        }
        return null;
    }
}

