/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.adapter;

import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.plugin.framework.adapter.ApplicationInfoAdapter;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.cache.PluginCache;
import com.nepxion.discovery.plugin.framework.cache.RuleCache;
import com.nepxion.discovery.plugin.framework.context.PluginContextHolder;
import com.netflix.loadbalancer.Server;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.serviceregistry.Registration;

public abstract class AbstractPluginAdapter
implements PluginAdapter {
    @Autowired
    protected Registration registration;
    @Autowired
    protected PluginCache pluginCache;
    @Autowired(required=false)
    protected PluginContextHolder pluginContextHolder;
    @Autowired
    protected RuleCache ruleCache;
    @Autowired(required=false)
    protected ApplicationInfoAdapter applicationInfoAdapter;
    @Value(value="${spring.application.group.key:group}")
    private String groupKey;
    @Value(value="${spring.application.type:unknown}")
    private String applicationType;
    protected Map<String, String> emptyMetadata = new HashMap<String, String>();

    @Override
    public String getGroupKey() {
        return this.groupKey;
    }

    @Override
    public String getGroup() {
        String groupKey = this.getGroupKey();
        String group = this.getGroup(groupKey);
        if (StringUtils.isEmpty((CharSequence)group)) {
            group = "default";
        }
        return group;
    }

    protected String getGroup(String groupKey) {
        return this.getMetadata().get(groupKey);
    }

    @Override
    public String getServiceType() {
        return this.applicationType;
    }

    @Override
    public String getServiceId() {
        return this.registration.getServiceId().toLowerCase();
    }

    @Override
    public String getServiceAppId() {
        if (this.applicationInfoAdapter != null) {
            return this.applicationInfoAdapter.getAppId();
        }
        return null;
    }

    @Override
    public String getHost() {
        return this.registration.getHost();
    }

    @Override
    public int getPort() {
        return this.registration.getPort();
    }

    @Override
    public String getContextPath() {
        return this.getMetadata().get("spring.application.context-path");
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.registration.getMetadata();
    }

    @Override
    public String getVersion() {
        String dynamicVersion = this.getDynamicVersion();
        if (StringUtils.isNotEmpty((CharSequence)dynamicVersion)) {
            return dynamicVersion;
        }
        return this.getLocalVersion();
    }

    @Override
    public String getLocalVersion() {
        String version = this.getMetadata().get("version");
        if (StringUtils.isEmpty((CharSequence)version)) {
            version = "default";
        }
        return version;
    }

    @Override
    public String getDynamicVersion() {
        return this.pluginCache.get("dynamicVersion");
    }

    @Override
    public void setDynamicVersion(String version) {
        this.pluginCache.put("dynamicVersion", version);
    }

    @Override
    public void clearDynamicVersion() {
        this.pluginCache.clear("dynamicVersion");
    }

    @Override
    public RuleEntity getRule() {
        RuleEntity dynamicRuleEntity = this.getDynamicRule();
        if (dynamicRuleEntity != null) {
            return dynamicRuleEntity;
        }
        return this.getLocalRule();
    }

    @Override
    public RuleEntity getLocalRule() {
        return this.ruleCache.get("rule");
    }

    @Override
    public void setLocalRule(RuleEntity ruleEntity) {
        this.ruleCache.put("rule", ruleEntity);
    }

    @Override
    public RuleEntity getDynamicRule() {
        return this.ruleCache.get("dynamicRule");
    }

    @Override
    public void setDynamicRule(RuleEntity ruleEntity) {
        this.ruleCache.put("dynamicRule", ruleEntity);
    }

    @Override
    public void clearDynamicRule() {
        this.ruleCache.clear("dynamicRule");
    }

    @Override
    public String getRegion() {
        String region = this.getMetadata().get("region");
        if (StringUtils.isEmpty((CharSequence)region)) {
            region = "default";
        }
        return region;
    }

    @Override
    public String getEnvironment() {
        String environment = this.getMetadata().get("env");
        if (StringUtils.isEmpty((CharSequence)environment)) {
            environment = "default";
        }
        return environment;
    }

    @Override
    public String getServerGroupKey(Server server) {
        String groupKey = this.getServerMetadata(server).get("spring.application.group.key");
        if (StringUtils.isEmpty((CharSequence)groupKey)) {
            groupKey = "group";
        }
        return groupKey;
    }

    @Override
    public String getServerGroup(Server server) {
        String serverGroupKey = this.getServerGroupKey(server);
        String serverGroup = this.getServerMetadata(server).get(serverGroupKey);
        if (StringUtils.isEmpty((CharSequence)serverGroup)) {
            serverGroup = "default";
        }
        return serverGroup;
    }

    @Override
    public String getServerServiceType(Server server) {
        return this.getServerMetadata(server).get("spring.application.type");
    }

    @Override
    public String getServerServiceId(Server server) {
        String serviceId = this.getServerMetadata(server).get("spring.application.name");
        if (StringUtils.isEmpty((CharSequence)serviceId)) {
            serviceId = server.getMetaInfo().getAppName();
        }
        if (StringUtils.isEmpty((CharSequence)serviceId)) {
            throw new DiscoveryException("Server ServiceId is null");
        }
        return serviceId.toLowerCase();
    }

    @Override
    public String getServerVersion(Server server) {
        String serverVersion = this.getServerMetadata(server).get("version");
        if (StringUtils.isEmpty((CharSequence)serverVersion)) {
            serverVersion = "default";
        }
        return serverVersion;
    }

    @Override
    public String getServerRegion(Server server) {
        String serverRegion = this.getServerMetadata(server).get("region");
        if (StringUtils.isEmpty((CharSequence)serverRegion)) {
            serverRegion = "default";
        }
        return serverRegion;
    }

    @Override
    public String getServerEnvironment(Server server) {
        String serverEnvironment = this.getServerMetadata(server).get("env");
        if (StringUtils.isEmpty((CharSequence)serverEnvironment)) {
            serverEnvironment = "default";
        }
        return serverEnvironment;
    }

    @Override
    public String getServerContextPath(Server server) {
        return this.getServerMetadata(server).get("spring.application.context-path");
    }

    @Override
    public Map<String, String> getInstanceMetadata(ServiceInstance serviceInstance) {
        return serviceInstance.getMetadata();
    }

    @Override
    public String getInstanceGroupKey(ServiceInstance serviceInstance) {
        String groupKey = this.getInstanceMetadata(serviceInstance).get("spring.application.group.key");
        if (StringUtils.isEmpty((CharSequence)groupKey)) {
            groupKey = "group";
        }
        return groupKey;
    }

    @Override
    public String getInstanceGroup(ServiceInstance serviceInstance) {
        String instanceGroupKey = this.getInstanceGroupKey(serviceInstance);
        String instanceGroup = this.getInstanceMetadata(serviceInstance).get(instanceGroupKey);
        if (StringUtils.isEmpty((CharSequence)instanceGroup)) {
            instanceGroup = "default";
        }
        return instanceGroup;
    }

    @Override
    public String getInstanceServiceType(ServiceInstance serviceInstance) {
        return this.getInstanceMetadata(serviceInstance).get("spring.application.type");
    }

    @Override
    public String getInstanceServiceId(ServiceInstance serviceInstance) {
        return serviceInstance.getServiceId().toLowerCase();
    }

    @Override
    public String getInstanceVersion(ServiceInstance serviceInstance) {
        String instanceVersion = this.getInstanceMetadata(serviceInstance).get("version");
        if (StringUtils.isEmpty((CharSequence)instanceVersion)) {
            instanceVersion = "default";
        }
        return instanceVersion;
    }

    @Override
    public String getInstanceRegion(ServiceInstance serviceInstance) {
        String instanceRegion = this.getInstanceMetadata(serviceInstance).get("region");
        if (StringUtils.isEmpty((CharSequence)instanceRegion)) {
            instanceRegion = "default";
        }
        return instanceRegion;
    }

    @Override
    public String getInstanceEnvironment(ServiceInstance serviceInstance) {
        String instanceEnvironment = this.getInstanceMetadata(serviceInstance).get("env");
        if (StringUtils.isEmpty((CharSequence)instanceEnvironment)) {
            instanceEnvironment = "default";
        }
        return instanceEnvironment;
    }

    @Override
    public String getInstanceContextPath(ServiceInstance serviceInstance) {
        return this.getInstanceMetadata(serviceInstance).get("spring.application.context-path");
    }

    @Override
    public String getPluginInfo(String previousPluginInfo) {
        String serviceId = this.getServiceId();
        String host = this.getHost();
        int port = this.getPort();
        String version = this.getVersion();
        String region = this.getRegion();
        String environment = this.getEnvironment();
        String group = this.getGroup();
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)previousPluginInfo)) {
            stringBuilder.append(previousPluginInfo + " -> ");
        }
        stringBuilder.append("[ID=" + serviceId + "]");
        stringBuilder.append("[H=" + host + ":" + port + "]");
        if (StringUtils.isNotEmpty((CharSequence)version)) {
            stringBuilder.append("[V=" + version + "]");
        }
        if (StringUtils.isNotEmpty((CharSequence)region)) {
            stringBuilder.append("[R=" + region + "]");
        }
        if (StringUtils.isNotEmpty((CharSequence)environment)) {
            stringBuilder.append("[E=" + environment + "]");
        }
        if (StringUtils.isNotEmpty((CharSequence)group)) {
            stringBuilder.append("[G=" + group + "]");
        }
        if (this.pluginContextHolder != null) {
            String spanId;
            String traceId = this.pluginContextHolder.getTraceId();
            if (StringUtils.isNotEmpty((CharSequence)traceId)) {
                stringBuilder.append("[TID=" + traceId + "]");
            }
            if (StringUtils.isNotEmpty((CharSequence)(spanId = this.pluginContextHolder.getSpanId()))) {
                stringBuilder.append("[SID=" + spanId + "]");
            }
        }
        return stringBuilder.toString();
    }
}

