/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.listener.discovery;

import com.nepxion.discovery.plugin.framework.adapter.EnvironmentRouteAdapter;
import com.nepxion.discovery.plugin.framework.listener.discovery.AbstractDiscoveryListener;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;

public class EnvironmentFilterDiscoveryListener
extends AbstractDiscoveryListener {
    @Autowired(required=false)
    private EnvironmentRouteAdapter environmentRouteAdapter;

    @Override
    public void onGetInstances(String serviceId, List<ServiceInstance> instances) {
        this.applyEnvironmentFilter(serviceId, instances);
    }

    private void applyEnvironmentFilter(String providerServiceId, List<ServiceInstance> instances) {
        String environment = this.pluginAdapter.getEnvironment();
        boolean validated = this.validate(instances, environment);
        Iterator<ServiceInstance> iterator = instances.iterator();
        while (iterator.hasNext()) {
            ServiceInstance serviceInstance = iterator.next();
            String instanceEnvironment = this.pluginAdapter.getInstanceEnvironment(serviceInstance);
            if (validated) {
                if (StringUtils.equals((CharSequence)instanceEnvironment, (CharSequence)environment)) continue;
                iterator.remove();
                continue;
            }
            if (this.environmentRouteAdapter != null && this.environmentRouteAdapter.isRouteEnabled()) {
                if (StringUtils.equals((CharSequence)instanceEnvironment, (CharSequence)this.environmentRouteAdapter.getEnvironmentRoute())) continue;
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
    }

    private boolean validate(List<ServiceInstance> instances, String environment) {
        for (ServiceInstance serviceInstance : instances) {
            String instanceEnvironment = this.pluginAdapter.getInstanceEnvironment(serviceInstance);
            if (!StringUtils.equals((CharSequence)instanceEnvironment, (CharSequence)environment)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onGetServices(List<String> services) {
    }

    @Override
    public int getOrder() {
        return -2147483645;
    }
}

