/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.listener.discovery;

import com.nepxion.discovery.common.entity.DiscoveryEntity;
import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.entity.VersionEntity;
import com.nepxion.discovery.common.entity.VersionFilterEntity;
import com.nepxion.discovery.plugin.framework.listener.discovery.AbstractDiscoveryListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.client.ServiceInstance;

public class VersionFilterDiscoveryListener
extends AbstractDiscoveryListener {
    @Override
    public void onGetInstances(String serviceId, List<ServiceInstance> instances) {
        String consumerServiceId = this.pluginAdapter.getServiceId();
        String consumerServiceVersion = this.pluginAdapter.getVersion();
        this.applyVersionFilter(consumerServiceId, consumerServiceVersion, serviceId, instances);
    }

    private void applyVersionFilter(String consumerServiceId, String consumerServiceVersion, String providerServiceId, List<ServiceInstance> instances) {
        if (StringUtils.isEmpty((CharSequence)consumerServiceVersion)) {
            return;
        }
        RuleEntity ruleEntity = this.pluginAdapter.getRule();
        if (ruleEntity == null) {
            return;
        }
        DiscoveryEntity discoveryEntity = ruleEntity.getDiscoveryEntity();
        if (discoveryEntity == null) {
            return;
        }
        VersionFilterEntity versionFilterEntity = discoveryEntity.getVersionFilterEntity();
        if (versionFilterEntity == null) {
            return;
        }
        Map versionEntityMap = versionFilterEntity.getVersionEntityMap();
        if (MapUtils.isEmpty((Map)versionEntityMap)) {
            return;
        }
        List versionEntityList = (List)versionEntityMap.get(consumerServiceId);
        if (CollectionUtils.isEmpty((Collection)versionEntityList)) {
            return;
        }
        ArrayList allNoFilterValueList = null;
        boolean providerConditionDefined = false;
        for (VersionEntity versionEntity : versionEntityList) {
            String providerServiceName = versionEntity.getProviderServiceName();
            if (!StringUtils.equalsIgnoreCase((CharSequence)providerServiceName, (CharSequence)providerServiceId)) continue;
            providerConditionDefined = true;
            List consumerVersionValueList = versionEntity.getConsumerVersionValueList();
            List providerVersionValueList = versionEntity.getProviderVersionValueList();
            if (CollectionUtils.isNotEmpty((Collection)consumerVersionValueList)) {
                if (!consumerVersionValueList.contains(consumerServiceVersion)) continue;
                if (allNoFilterValueList == null) {
                    allNoFilterValueList = new ArrayList();
                }
                if (!CollectionUtils.isNotEmpty((Collection)providerVersionValueList)) continue;
                allNoFilterValueList.addAll(providerVersionValueList);
                continue;
            }
            if (allNoFilterValueList == null) {
                allNoFilterValueList = new ArrayList();
            }
            if (!CollectionUtils.isNotEmpty((Collection)providerVersionValueList)) continue;
            allNoFilterValueList.addAll(providerVersionValueList);
        }
        if (allNoFilterValueList != null) {
            if (allNoFilterValueList.isEmpty()) {
                return;
            }
            Iterator<ServiceInstance> iterator = instances.iterator();
            while (iterator.hasNext()) {
                ServiceInstance serviceInstance = iterator.next();
                String instanceVersion = this.pluginAdapter.getInstanceVersion(serviceInstance);
                if (allNoFilterValueList.contains(instanceVersion)) continue;
                iterator.remove();
            }
        } else if (providerConditionDefined) {
            instances.clear();
        }
    }

    @Override
    public void onGetServices(List<String> services) {
    }

    @Override
    public int getOrder() {
        return -2147483647;
    }
}

