/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.listener.loadbalance;

import com.nepxion.discovery.plugin.framework.adapter.EnvironmentRouteAdapter;
import com.nepxion.discovery.plugin.framework.listener.loadbalance.AbstractLoadBalanceListener;
import com.netflix.loadbalancer.Server;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class EnvironmentFilterLoadBalanceListener
extends AbstractLoadBalanceListener {
    @Autowired(required=false)
    private EnvironmentRouteAdapter environmentRouteAdapter;

    @Override
    public void onGetServers(String serviceId, List<? extends Server> servers) {
        this.applyEnvironmentFilter(serviceId, servers);
    }

    private void applyEnvironmentFilter(String providerServiceId, List<? extends Server> servers) {
        String environment = this.pluginAdapter.getEnvironment();
        if (StringUtils.equals((CharSequence)environment, (CharSequence)"default")) {
            return;
        }
        boolean validated = this.validate(servers, environment);
        Iterator<? extends Server> iterator = servers.iterator();
        while (iterator.hasNext()) {
            Server server = iterator.next();
            String serverEnvironment = this.pluginAdapter.getServerEnvironment(server);
            if (validated) {
                if (StringUtils.equals((CharSequence)serverEnvironment, (CharSequence)environment)) continue;
                iterator.remove();
                continue;
            }
            if (this.environmentRouteAdapter != null && this.environmentRouteAdapter.isRouteEnabled()) {
                if (StringUtils.equals((CharSequence)serverEnvironment, (CharSequence)this.environmentRouteAdapter.getEnvironmentRoute())) continue;
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
    }

    private boolean validate(List<? extends Server> servers, String environment) {
        for (Server server : servers) {
            String serverEnvironment = this.pluginAdapter.getServerEnvironment(server);
            if (!StringUtils.equals((CharSequence)serverEnvironment, (CharSequence)environment)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getOrder() {
        return -2147483645;
    }
}

