/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class FileContextUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FileContextUtil.class);

    public static File getFile(ApplicationContext applicationContext, String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("File path isn't set");
        }
        LOG.info("File path is {}", (Object)path);
        try {
            String filePath = applicationContext.getEnvironment().resolvePlaceholders(path);
            return applicationContext.getResource(filePath).getFile();
        }
        catch (Exception e) {
            LOG.warn("File [{}] isn't found or invalid, ignore to load...", (Object)path);
            return null;
        }
    }

    public static InputStream getInputStream(ApplicationContext applicationContext, String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("File path isn't set");
        }
        LOG.info("File path is {}", (Object)path);
        try {
            String filePath = applicationContext.getEnvironment().resolvePlaceholders(path);
            return applicationContext.getResource(filePath).getInputStream();
        }
        catch (Exception e) {
            LOG.warn("File [{}] isn't found or invalid, ignore to load...", (Object)path);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getText(ApplicationContext applicationContext, String path) {
        block7: {
            InputStream inputStream = null;
            try {
                inputStream = FileContextUtil.getInputStream(applicationContext, path);
                if (inputStream == null) break block7;
                try {
                    String string = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
                    return string;
                }
                catch (IOException e) {
                    LOG.warn("InputStream to String failed, ignore to load...");
                }
            }
            finally {
                if (inputStream != null) {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
        }
        return null;
    }
}

