/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.sentinel.monitor.callback;

import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.node.DefaultNode;
import com.alibaba.csp.sentinel.slotchain.ProcessorSlotEntryCallback;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.fastjson.JSON;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.context.PluginContextAware;
import org.apache.commons.lang3.StringUtils;

public abstract class SentinelTracerProcessorSlotEntryCallback<S>
implements ProcessorSlotEntryCallback<DefaultNode> {
    private Boolean tracerSentinelRuleOutputEnabled = Boolean.valueOf(System.getProperty("spring.application.strategy.tracer.sentinel.rule.output.enabled", "true"));
    private Boolean tracerSentinelArgsOutputEnabled = Boolean.valueOf(System.getProperty("spring.application.strategy.tracer.sentinel.args.output.enabled", "false"));

    public void onPass(Context context, ResourceWrapper resourceWrapper, DefaultNode param, int count, Object ... args) throws Exception {
    }

    public void onBlocked(BlockException e, Context context, ResourceWrapper resourceWrapper, DefaultNode param, int count, Object ... args) {
        S span = this.buildSpan();
        PluginAdapter pluginAdapter = (PluginAdapter)PluginContextAware.getStaticApplicationContext().getBean(PluginAdapter.class);
        this.outputSpan(span, "plugin", context.getName());
        this.outputSpan(span, "n-d-service-group", pluginAdapter.getGroup());
        this.outputSpan(span, "n-d-service-type", pluginAdapter.getServiceType());
        String serviceAppId = pluginAdapter.getServiceAppId();
        if (StringUtils.isNotEmpty((CharSequence)serviceAppId)) {
            this.outputSpan(span, "n-d-service-app-id", serviceAppId);
        }
        this.outputSpan(span, "n-d-service-id", pluginAdapter.getServiceId());
        this.outputSpan(span, "n-d-service-address", pluginAdapter.getHost() + ":" + pluginAdapter.getPort());
        this.outputSpan(span, "n-d-service-version", pluginAdapter.getVersion());
        this.outputSpan(span, "n-d-service-region", pluginAdapter.getRegion());
        this.outputSpan(span, "n-d-service-env", pluginAdapter.getEnvironment());
        this.outputSpan(span, "origin", context.getOrigin());
        this.outputSpan(span, "async", String.valueOf(context.isAsync()));
        this.outputSpan(span, "resource.name", resourceWrapper.getName());
        this.outputSpan(span, "resource.showname", resourceWrapper.getShowName());
        this.outputSpan(span, "resource.type", String.valueOf(resourceWrapper.getResourceType()));
        this.outputSpan(span, "entry.type", resourceWrapper.getEntryType().toString());
        this.outputSpan(span, "rule.limit.app", e.getRuleLimitApp());
        if (this.tracerSentinelRuleOutputEnabled.booleanValue()) {
            this.outputSpan(span, "rule", e.getRule().toString());
        }
        this.outputSpan(span, "cause", e.getClass().getName());
        this.outputSpan(span, "block.exception", e.getMessage());
        this.outputSpan(span, "count", String.valueOf(count));
        if (this.tracerSentinelArgsOutputEnabled.booleanValue()) {
            this.outputSpan(span, "args", JSON.toJSONString((Object)args));
        }
        this.finishSpan(span);
    }

    protected abstract S buildSpan();

    protected abstract void outputSpan(S var1, String var2, String var3);

    protected abstract void finishSpan(S var1);
}

