/*
 * Decompiled with CFR 0.152.
 */
package com.noenv.cronutils.impl;

import com.cronutils.model.Cron;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import com.noenv.cronutils.CronScheduler;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Objects;

public class CronSchedulerImpl
implements CronScheduler,
Handler<Long> {
    private final Vertx vertx;
    private final ExecutionTime expression;
    private Handler<CronScheduler> handler;
    private long timerId;
    private ZonedDateTime executionTime;

    public CronSchedulerImpl(Vertx vertx, String cronExpression, CronDefinition definition) {
        this.vertx = vertx;
        this.timerId = -1L;
        CronParser parser = new CronParser(definition);
        this.expression = ExecutionTime.forCron((Cron)parser.parse(cronExpression));
    }

    @Override
    public CronScheduler schedule(Handler<CronScheduler> handler) {
        Objects.requireNonNull(handler);
        if (this.handler != null) {
            throw new IllegalArgumentException("Scheduler is already registered.");
        }
        this.handler = handler;
        this.scheduleNextTimer(0L);
        return this;
    }

    @Override
    public void cancel() {
        if (this.vertx.cancelTimer(this.timerId)) {
            this.handler = null;
        }
        this.timerId = -1L;
    }

    public final void handle(Long id) {
        this.timerId = -1L;
        if (this.handler == null) {
            return;
        }
        this.scheduleNextTimer(20L);
        this.handler.handle((Object)this);
    }

    @Override
    public boolean active() {
        return this.timerId >= 0L;
    }

    private void scheduleNextTimer(long addMilliseconds) {
        ZonedDateTime now = ZonedDateTime.now();
        if (this.executionTime == null) {
            this.executionTime = now;
        }
        this.expression.nextExecution(this.executionTime).ifPresent(next -> {
            this.executionTime = next;
            long delay = this.getNextDelay(now);
            this.timerId = this.vertx.setTimer(delay + addMilliseconds, (Handler)this);
        });
    }

    private long getNextDelay(ZonedDateTime time) {
        Duration timeToNextExecution = Duration.between(time, this.executionTime);
        return Math.max(1L, timeToNextExecution.toMillis());
    }
}

