/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.apache.http.impl.cookie;

import com.pdd.pop.ext.apache.http.annotation.Contract;
import com.pdd.pop.ext.apache.http.annotation.ThreadingBehavior;
import com.pdd.pop.ext.apache.http.cookie.CommonCookieAttributeHandler;
import com.pdd.pop.ext.apache.http.cookie.Cookie;
import com.pdd.pop.ext.apache.http.cookie.CookieOrigin;
import com.pdd.pop.ext.apache.http.cookie.MalformedCookieException;
import com.pdd.pop.ext.apache.http.cookie.SetCookie;
import com.pdd.pop.ext.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import com.pdd.pop.ext.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

