/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly;

import com.pdd.pop.ext.glassfish.grizzly.asyncqueue.WritableMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;

public class FileTransfer
implements WritableMessage {
    private FileChannel fileChannel;
    private long len;
    private long pos;

    public FileTransfer(File f) {
        this(f, 0L, f.length());
    }

    public FileTransfer(File f, long pos, long len) {
        if (f == null) {
            throw new IllegalArgumentException("f cannot be null.");
        }
        if (!f.exists()) {
            throw new IllegalArgumentException("File " + f.getAbsolutePath() + " does not exist.");
        }
        if (!f.canRead()) {
            throw new IllegalArgumentException("File " + f.getAbsolutePath() + " is not readable.");
        }
        if (f.isDirectory()) {
            throw new IllegalArgumentException("File " + f.getAbsolutePath() + " is a directory.");
        }
        if (pos < 0L) {
            throw new IllegalArgumentException("The pos argument cannot be negative.");
        }
        if (len < 0L) {
            throw new IllegalArgumentException("The len argument cannot be negative.");
        }
        if (pos > f.length()) {
            throw new IllegalArgumentException("Illegal offset");
        }
        if (f.length() - pos < len) {
            throw new IllegalArgumentException("Specified length exceeds available bytes to transfer.");
        }
        this.pos = pos;
        this.len = len;
        try {
            this.fileChannel = new FileInputStream(f).getChannel();
        }
        catch (FileNotFoundException fnfe) {
            throw new IllegalStateException(fnfe);
        }
    }

    public long writeTo(WritableByteChannel c) throws IOException {
        long written = this.fileChannel.transferTo(this.pos, this.len, c);
        this.pos += written;
        this.len -= written;
        return written;
    }

    @Override
    public boolean hasRemaining() {
        return this.len != 0L;
    }

    @Override
    public int remaining() {
        return this.len > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean release() {
        try {
            this.fileChannel.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.fileChannel = null;
        }
        return true;
    }

    @Override
    public boolean isExternal() {
        return true;
    }
}

