/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.asyncqueue;

import com.pdd.pop.ext.glassfish.grizzly.Buffer;
import com.pdd.pop.ext.glassfish.grizzly.CompletionHandler;
import com.pdd.pop.ext.glassfish.grizzly.Connection;
import com.pdd.pop.ext.glassfish.grizzly.Grizzly;
import com.pdd.pop.ext.glassfish.grizzly.Interceptor;
import com.pdd.pop.ext.glassfish.grizzly.ReadResult;
import com.pdd.pop.ext.glassfish.grizzly.ThreadCache;
import com.pdd.pop.ext.glassfish.grizzly.asyncqueue.AsyncQueueRecord;
import com.pdd.pop.ext.glassfish.grizzly.asyncqueue.RecordReadResult;
import com.pdd.pop.ext.glassfish.grizzly.utils.DebugPoint;

public final class AsyncReadQueueRecord
extends AsyncQueueRecord<ReadResult> {
    private static final ThreadCache.CachedTypeIndex<AsyncReadQueueRecord> CACHE_IDX = ThreadCache.obtainIndex(AsyncReadQueueRecord.class, 2);
    protected Interceptor interceptor;
    private final RecordReadResult readResult = new RecordReadResult();

    public static AsyncReadQueueRecord create(Connection connection, Buffer message, CompletionHandler completionHandler, Interceptor<ReadResult> interceptor) {
        AsyncReadQueueRecord asyncReadQueueRecord = ThreadCache.takeFromCache(CACHE_IDX);
        if (asyncReadQueueRecord != null) {
            asyncReadQueueRecord.isRecycled = false;
            asyncReadQueueRecord.set(connection, message, completionHandler, interceptor);
            return asyncReadQueueRecord;
        }
        return new AsyncReadQueueRecord(connection, message, completionHandler, interceptor);
    }

    private AsyncReadQueueRecord(Connection connection, Buffer message, CompletionHandler completionHandler, Interceptor<ReadResult> interceptor) {
        this.set(connection, message, completionHandler, interceptor);
    }

    public final Interceptor getInterceptor() {
        this.checkRecycled();
        return this.interceptor;
    }

    public final void notifyComplete() {
        if (this.completionHandler != null) {
            this.completionHandler.completed(this.readResult);
        }
    }

    public boolean isFinished() {
        return this.readResult.getReadSize() > 0 || !((Buffer)this.message).hasRemaining();
    }

    @Override
    public ReadResult getCurrentResult() {
        return this.readResult;
    }

    protected final void set(Connection connection, Object message, CompletionHandler completionHandler, Interceptor interceptor) {
        this.set(connection, message, completionHandler);
        this.interceptor = interceptor;
        this.readResult.set(connection, message, null, 0);
    }

    protected final void reset() {
        this.set(null, null, null);
        this.readResult.recycle();
        this.interceptor = null;
    }

    @Override
    public void recycle() {
        this.checkRecycled();
        this.reset();
        this.isRecycled = true;
        if (Grizzly.isTrackingThreadCache()) {
            this.recycleTrack = new DebugPoint(new Exception(), Thread.currentThread().getName());
        }
        ThreadCache.putToCache(CACHE_IDX, this);
    }
}

