/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.filterchain;

import com.pdd.pop.ext.glassfish.grizzly.Connection;
import com.pdd.pop.ext.glassfish.grizzly.TransformationException;
import com.pdd.pop.ext.glassfish.grizzly.TransformationResult;
import com.pdd.pop.ext.glassfish.grizzly.Transformer;
import com.pdd.pop.ext.glassfish.grizzly.filterchain.BaseFilter;
import com.pdd.pop.ext.glassfish.grizzly.filterchain.CodecFilter;
import com.pdd.pop.ext.glassfish.grizzly.filterchain.FilterChainContext;
import com.pdd.pop.ext.glassfish.grizzly.filterchain.NextAction;
import java.io.IOException;

public abstract class AbstractCodecFilter<K, L>
extends BaseFilter
implements CodecFilter<K, L> {
    private final Transformer<K, L> decoder;
    private final Transformer<L, K> encoder;

    public AbstractCodecFilter(Transformer<K, L> decoder, Transformer<L, K> encoder) {
        this.decoder = decoder;
        this.encoder = encoder;
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        Object message = ctx.getMessage();
        TransformationResult<K, L> result = this.decoder.transform(connection, message);
        switch (result.getStatus()) {
            case COMPLETE: {
                K remainder = result.getExternalRemainder();
                boolean hasRemaining = this.decoder.hasInputRemaining(connection, remainder);
                this.decoder.release(connection);
                ctx.setMessage(result.getMessage());
                return hasRemaining ? ctx.getInvokeAction(remainder) : ctx.getInvokeAction();
            }
            case INCOMPLETE: {
                return ctx.getStopAction(message);
            }
            case ERROR: {
                throw new TransformationException(this.getClass().getName() + " transformation error: (" + result.getErrorCode() + ") " + result.getErrorDescription());
            }
        }
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        Object message = ctx.getMessage();
        TransformationResult<L, K> result = this.encoder.transform(connection, message);
        switch (result.getStatus()) {
            case COMPLETE: {
                ctx.setMessage(result.getMessage());
                L remainder = result.getExternalRemainder();
                boolean hasRemaining = this.encoder.hasInputRemaining(connection, remainder);
                this.encoder.release(connection);
                return hasRemaining ? ctx.getInvokeAction(remainder) : ctx.getInvokeAction();
            }
            case INCOMPLETE: {
                return ctx.getStopAction(message);
            }
            case ERROR: {
                throw new TransformationException(this.getClass().getName() + " transformation error: (" + result.getErrorCode() + ") " + result.getErrorDescription());
            }
        }
        return ctx.getInvokeAction();
    }

    @Override
    public Transformer<K, L> getDecoder() {
        return this.decoder;
    }

    @Override
    public Transformer<L, K> getEncoder() {
        return this.encoder;
    }
}

