/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.http;

import com.pdd.pop.ext.glassfish.grizzly.Buffer;
import com.pdd.pop.ext.glassfish.grizzly.http.Cookies;
import com.pdd.pop.ext.glassfish.grizzly.http.util.CookieParserUtils;

public class CookiesBuilder {
    public static ClientCookiesBuilder client() {
        return CookiesBuilder.client(false, false);
    }

    public static ClientCookiesBuilder client(boolean strictVersionOneCompliant) {
        return new ClientCookiesBuilder(strictVersionOneCompliant, false);
    }

    public static ClientCookiesBuilder client(boolean strictVersionOneCompliant, boolean rfc6265Enabled) {
        return new ClientCookiesBuilder(strictVersionOneCompliant, rfc6265Enabled);
    }

    public static ServerCookiesBuilder server() {
        return CookiesBuilder.server(false, false);
    }

    public static ServerCookiesBuilder server(boolean strictVersionOneCompliant) {
        return new ServerCookiesBuilder(strictVersionOneCompliant, false);
    }

    public static ServerCookiesBuilder server(boolean strictVersionOneCompliant, boolean rfc6265Enabled) {
        return new ServerCookiesBuilder(strictVersionOneCompliant, rfc6265Enabled);
    }

    public static abstract class AbstractCookiesBuilder<E extends AbstractCookiesBuilder> {
        protected final boolean strictVersionOneCompliant;
        protected final boolean rfc6265Enabled;
        protected final Cookies cookies = new Cookies();

        public AbstractCookiesBuilder(boolean strictVersionOneCompliant, boolean rfc6265Enabled) {
            this.strictVersionOneCompliant = strictVersionOneCompliant;
            this.rfc6265Enabled = rfc6265Enabled;
        }

        public abstract E parse(Buffer var1);

        public abstract E parse(Buffer var1, int var2, int var3);

        public abstract E parse(String var1);

        public Cookies build() {
            return this.cookies;
        }
    }

    public static class ServerCookiesBuilder
    extends AbstractCookiesBuilder<ServerCookiesBuilder> {
        public ServerCookiesBuilder(boolean strictVersionOneCompliant, boolean rfc6265Enabled) {
            super(strictVersionOneCompliant, rfc6265Enabled);
        }

        @Override
        public ServerCookiesBuilder parse(Buffer cookiesHeader) {
            return this.parse(cookiesHeader, cookiesHeader.position(), cookiesHeader.limit());
        }

        @Override
        public ServerCookiesBuilder parse(Buffer cookiesHeader, int position, int limit) {
            CookieParserUtils.parseServerCookies(this.cookies, cookiesHeader, position, limit - position, this.strictVersionOneCompliant, this.rfc6265Enabled);
            return this;
        }

        @Override
        public ServerCookiesBuilder parse(String cookiesHeader) {
            CookieParserUtils.parseServerCookies(this.cookies, cookiesHeader, this.strictVersionOneCompliant, this.rfc6265Enabled);
            return this;
        }
    }

    public static class ClientCookiesBuilder
    extends AbstractCookiesBuilder<ClientCookiesBuilder> {
        public ClientCookiesBuilder(boolean strictVersionOneCompliant, boolean rfc6265Enabled) {
            super(strictVersionOneCompliant, rfc6265Enabled);
        }

        @Override
        public ClientCookiesBuilder parse(Buffer cookiesHeader) {
            return this.parse(cookiesHeader, cookiesHeader.position(), cookiesHeader.limit());
        }

        @Override
        public ClientCookiesBuilder parse(Buffer cookiesHeader, int position, int limit) {
            CookieParserUtils.parseClientCookies(this.cookies, cookiesHeader, position, limit - position, this.strictVersionOneCompliant, this.rfc6265Enabled);
            return this;
        }

        @Override
        public ClientCookiesBuilder parse(String cookiesHeader) {
            CookieParserUtils.parseClientCookies(this.cookies, cookiesHeader, this.strictVersionOneCompliant, this.rfc6265Enabled);
            return this;
        }
    }
}

