/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.http;

import com.pdd.pop.ext.glassfish.grizzly.Buffer;
import com.pdd.pop.ext.glassfish.grizzly.ThreadCache;
import com.pdd.pop.ext.glassfish.grizzly.http.HttpBrokenContentException;
import com.pdd.pop.ext.glassfish.grizzly.http.HttpContent;
import com.pdd.pop.ext.glassfish.grizzly.http.HttpHeader;

public class HttpBrokenContent
extends HttpContent {
    private static final ThreadCache.CachedTypeIndex<HttpBrokenContent> CACHE_IDX = ThreadCache.obtainIndex(HttpBrokenContent.class, 1);
    private Throwable exception;

    public static HttpBrokenContent create() {
        return HttpBrokenContent.create(null);
    }

    public static HttpBrokenContent create(HttpHeader httpHeader) {
        HttpBrokenContent httpBrokenContent = ThreadCache.takeFromCache(CACHE_IDX);
        if (httpBrokenContent != null) {
            httpBrokenContent.httpHeader = httpHeader;
            return httpBrokenContent;
        }
        return new HttpBrokenContent(httpHeader);
    }

    public static Builder builder(HttpHeader httpHeader) {
        return (Builder)new Builder().httpHeader(httpHeader);
    }

    protected HttpBrokenContent(HttpHeader httpHeader) {
        super(httpHeader);
    }

    public Throwable getException() {
        return this.exception;
    }

    @Override
    public Buffer getContent() {
        throw this.exception instanceof HttpBrokenContentException ? (HttpBrokenContentException)this.exception : new HttpBrokenContentException(this.exception);
    }

    @Override
    public final boolean isLast() {
        return true;
    }

    @Override
    protected void reset() {
        this.exception = null;
        super.reset();
    }

    @Override
    public void recycle() {
        this.reset();
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    public static final class Builder
    extends HttpContent.Builder<Builder> {
        private Throwable cause;

        protected Builder() {
        }

        public final Builder error(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public final HttpBrokenContent build() {
            HttpBrokenContent httpBrokenContent = (HttpBrokenContent)super.build();
            if (this.cause == null) {
                throw new IllegalStateException("No cause specified");
            }
            httpBrokenContent.exception = this.cause;
            return httpBrokenContent;
        }

        @Override
        protected HttpContent create() {
            return HttpBrokenContent.create();
        }
    }
}

