/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.http;

import com.pdd.pop.ext.glassfish.grizzly.ThreadCache;
import com.pdd.pop.ext.glassfish.grizzly.http.HttpRequestPacket;
import com.pdd.pop.ext.glassfish.grizzly.http.ProcessingState;

class HttpRequestPacketImpl
extends HttpRequestPacket {
    private static final ThreadCache.CachedTypeIndex<HttpRequestPacketImpl> CACHE_IDX = ThreadCache.obtainIndex(HttpRequestPacketImpl.class, 16);
    private final ProcessingState processingState = new ProcessingState();

    public static HttpRequestPacketImpl create() {
        HttpRequestPacketImpl httpRequestImpl = ThreadCache.takeFromCache(CACHE_IDX);
        if (httpRequestImpl != null) {
            return httpRequestImpl;
        }
        return new HttpRequestPacketImpl(){

            @Override
            public void recycle() {
                super.recycle();
                ThreadCache.putToCache(CACHE_IDX, this);
            }
        };
    }

    protected HttpRequestPacketImpl() {
        this.isExpectContent = true;
    }

    @Override
    public ProcessingState getProcessingState() {
        return this.processingState;
    }

    @Override
    protected void reset() {
        this.processingState.recycle();
        this.isExpectContent = true;
        super.reset();
    }

    @Override
    public void recycle() {
        if (this.isExpectContent()) {
            return;
        }
        this.reset();
    }
}

