/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.http.io;

import com.pdd.pop.ext.glassfish.grizzly.Buffer;
import com.pdd.pop.ext.glassfish.grizzly.memory.Buffers;
import com.pdd.pop.ext.glassfish.grizzly.memory.HeapBuffer;
import com.pdd.pop.ext.glassfish.grizzly.memory.MemoryManager;
import java.util.Arrays;

final class TemporaryHeapBuffer
extends HeapBuffer {
    boolean isDisposed;
    boolean hasClonedArray;

    TemporaryHeapBuffer() {
    }

    void reset(byte[] heap, int offset, int len) {
        this.heap = heap;
        this.offset = offset;
        this.cap = len;
        this.lim = len;
        this.pos = 0;
        this.byteBuffer = null;
        this.isDisposed = false;
        this.hasClonedArray = false;
    }

    Buffer cloneContent(MemoryManager memoryManager) {
        Object buffer;
        int length = this.remaining();
        if (!this.hasClonedArray) {
            buffer = memoryManager.allocate(length);
            buffer.put(this.heap, this.offset + this.pos, length);
            buffer.flip();
        } else {
            buffer = Buffers.wrap(memoryManager, this.heap, this.offset + this.pos, length);
        }
        buffer.allowBufferDispose(true);
        this.dispose();
        return buffer;
    }

    @Override
    protected void onShareHeap() {
        if (!this.hasClonedArray) {
            this.heap = Arrays.copyOfRange(this.heap, this.offset, this.offset + this.cap);
            this.offset = 0;
            this.hasClonedArray = true;
        }
        super.onShareHeap();
    }

    @Override
    public void dispose() {
        this.isDisposed = true;
        super.dispose();
    }

    boolean isDisposed() {
        return this.isDisposed;
    }

    public void recycle() {
        this.reset(null, 0, 0);
    }
}

