/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.http.server;

import com.pdd.pop.ext.glassfish.grizzly.http.CompressionConfig;
import com.pdd.pop.ext.glassfish.grizzly.http.EncodingFilter;
import com.pdd.pop.ext.glassfish.grizzly.http.HttpHeader;
import com.pdd.pop.ext.glassfish.grizzly.http.HttpRequestPacket;
import com.pdd.pop.ext.glassfish.grizzly.http.HttpResponsePacket;
import com.pdd.pop.ext.glassfish.grizzly.http.server.CompressionLevel;
import com.pdd.pop.ext.glassfish.grizzly.http.util.DataChunk;
import com.pdd.pop.ext.glassfish.grizzly.http.util.Header;
import com.pdd.pop.ext.glassfish.grizzly.http.util.MimeHeaders;
import java.util.Arrays;

public class CompressionEncodingFilter
implements EncodingFilter {
    private final CompressionConfig compressionConfig;
    private final String[] aliases;

    public CompressionEncodingFilter(CompressionConfig compressionConfig, String[] aliases) {
        this.compressionConfig = new CompressionConfig(compressionConfig);
        this.aliases = Arrays.copyOf(aliases, aliases.length);
    }

    public CompressionEncodingFilter(CompressionConfig.CompressionModeI compressionMode, int compressionMinSize, String[] compressableMimeTypes, String[] noCompressionUserAgents, String[] aliases) {
        CompressionConfig.CompressionMode mode;
        if (compressionMode instanceof CompressionConfig.CompressionMode) {
            mode = (CompressionConfig.CompressionMode)compressionMode;
        } else {
            assert (compressionMode instanceof CompressionLevel);
            mode = ((CompressionLevel)compressionMode).normalize();
        }
        this.compressionConfig = new CompressionConfig(mode, compressionMinSize, null, null);
        this.compressionConfig.setCompressableMimeTypes(compressableMimeTypes);
        this.compressionConfig.setNoCompressionUserAgents(noCompressionUserAgents);
        this.aliases = Arrays.copyOf(aliases, aliases.length);
    }

    @Override
    public boolean applyEncoding(HttpHeader httpPacket) {
        if (httpPacket.isRequest()) {
            assert (httpPacket instanceof HttpRequestPacket);
            return false;
        }
        assert (httpPacket instanceof HttpResponsePacket);
        return CompressionEncodingFilter.canCompressHttpResponse((HttpResponsePacket)httpPacket, this.compressionConfig, this.aliases);
    }

    @Override
    public boolean applyDecoding(HttpHeader httpPacket) {
        return false;
    }

    protected static boolean canCompressHttpResponse(HttpResponsePacket response, CompressionConfig compressionConfig, String[] aliases) {
        if (!response.getContentEncodings().isEmpty()) {
            return false;
        }
        MimeHeaders responseHeaders = response.getHeaders();
        DataChunk contentEncodingMB = responseHeaders.getValue(Header.ContentEncoding);
        if (contentEncodingMB != null && !contentEncodingMB.isNull()) {
            return false;
        }
        if (!CompressionConfig.isClientSupportCompression(compressionConfig, response.getRequest(), aliases)) {
            return false;
        }
        if (compressionConfig.getCompressionMode() == CompressionConfig.CompressionMode.FORCE) {
            response.setChunked(true);
            response.setContentLength(-1);
            return true;
        }
        long contentLength = response.getContentLength();
        if ((contentLength == -1L || contentLength >= (long)compressionConfig.getCompressionMinSize()) && compressionConfig.checkMimeType(response.getContentType())) {
            response.setChunked(true);
            response.setContentLength(-1);
            return true;
        }
        return false;
    }
}

