/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.http.server;

import com.pdd.pop.ext.glassfish.grizzly.http.server.HttpHandler;
import com.pdd.pop.ext.glassfish.grizzly.http.server.HttpHandlerRegistration;
import com.pdd.pop.ext.glassfish.grizzly.http.server.HttpServer;
import com.pdd.pop.ext.glassfish.grizzly.http.server.HttpServerMonitoringConfig;
import com.pdd.pop.ext.glassfish.grizzly.http.server.ServerFilterConfiguration;
import com.pdd.pop.ext.glassfish.grizzly.http.server.jmxbase.JmxEventListener;
import com.pdd.pop.ext.glassfish.grizzly.utils.DataStructures;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;

public class ServerConfiguration
extends ServerFilterConfiguration {
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger(-1);
    private static final HttpHandlerRegistration[] ROOT_MAPPING = new HttpHandlerRegistration[]{HttpHandlerRegistration.ROOT};
    final Map<HttpHandler, HttpHandlerRegistration[]> handlers = DataStructures.getConcurrentMap();
    private final Map<HttpHandler, HttpHandlerRegistration[]> unmodifiableHandlers = Collections.unmodifiableMap(this.handlers);
    final List<HttpHandler> orderedHandlers = new LinkedList<HttpHandler>();
    private final Set<JmxEventListener> jmxEventListeners = new CopyOnWriteArraySet<JmxEventListener>();
    private final HttpServerMonitoringConfig monitoringConfig = new HttpServerMonitoringConfig();
    private String name;
    final HttpServer instance;
    private boolean jmxEnabled;
    private boolean allowPayloadForUndefinedHttpMethods;
    private long maxPayloadRemainderToSkip = -1L;
    final Object handlersSync = new Object();

    ServerConfiguration(HttpServer instance) {
        this.instance = instance;
    }

    public void addHttpHandler(HttpHandler httpHandler) {
        this.addHttpHandler(httpHandler, ROOT_MAPPING);
    }

    public void addHttpHandler(HttpHandler httpHandler, String ... mappings) {
        if (mappings == null || mappings.length == 0) {
            this.addHttpHandler(httpHandler, ROOT_MAPPING);
            return;
        }
        HttpHandlerRegistration[] registrations = new HttpHandlerRegistration[mappings.length];
        for (int i = 0; i < mappings.length; ++i) {
            registrations[i] = HttpHandlerRegistration.fromString(mappings[i]);
        }
        this.addHttpHandler(httpHandler, registrations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHttpHandler(HttpHandler httpHandler, HttpHandlerRegistration ... mapping) {
        Object object = this.handlersSync;
        synchronized (object) {
            if (mapping == null || mapping.length == 0) {
                mapping = ROOT_MAPPING;
            }
            if (this.handlers.put(httpHandler, mapping) != null) {
                this.orderedHandlers.remove(httpHandler);
            }
            this.orderedHandlers.add(httpHandler);
            this.instance.onAddHttpHandler(httpHandler, mapping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean removeHttpHandler(HttpHandler httpHandler) {
        Object object = this.handlersSync;
        synchronized (object) {
            boolean result;
            boolean bl = result = this.handlers.remove(httpHandler) != null;
            if (result) {
                this.orderedHandlers.remove(httpHandler);
                this.instance.onRemoveHttpHandler(httpHandler);
            }
            return result;
        }
    }

    public Map<HttpHandler, String[]> getHttpHandlers() {
        HashMap<HttpHandler, String[]> map = new HashMap<HttpHandler, String[]>(this.unmodifiableHandlers.size());
        for (Map.Entry<HttpHandler, HttpHandlerRegistration[]> entry : this.unmodifiableHandlers.entrySet()) {
            HttpHandlerRegistration[] regs = entry.getValue();
            String[] strRegs = new String[regs.length];
            for (int i = 0; i < regs.length; ++i) {
                String contextPath = regs[i].getContextPath();
                String urlPattern = regs[i].getUrlPattern();
                strRegs[i] = contextPath == null ? urlPattern : (urlPattern == null ? contextPath : (contextPath.endsWith("/") && urlPattern.startsWith("/") ? contextPath.substring(0, contextPath.length() - 1) + urlPattern : contextPath + urlPattern));
            }
            map.put(entry.getKey(), strRegs);
        }
        return Collections.unmodifiableMap(map);
    }

    public Map<HttpHandler, HttpHandlerRegistration[]> getHttpHandlersWithMapping() {
        return this.unmodifiableHandlers;
    }

    public HttpServerMonitoringConfig getMonitoringConfig() {
        return this.monitoringConfig;
    }

    public String getName() {
        if (this.name == null) {
            if (!this.instance.isStarted()) {
                return null;
            }
            int count = INSTANCE_COUNT.incrementAndGet();
            this.name = count == 0 ? "HttpServer" : "HttpServer-" + count;
        }
        return this.name;
    }

    public void setName(String name) {
        if (!this.instance.isStarted()) {
            this.name = name;
        }
    }

    public boolean isJmxEnabled() {
        return this.jmxEnabled;
    }

    public void setJmxEnabled(boolean jmxEnabled) {
        this.jmxEnabled = jmxEnabled;
        if (this.instance.isStarted()) {
            if (jmxEnabled) {
                this.instance.enableJMX();
                if (!this.jmxEventListeners.isEmpty()) {
                    for (JmxEventListener l : this.jmxEventListeners) {
                        l.jmxEnabled();
                    }
                }
            } else {
                if (!this.jmxEventListeners.isEmpty()) {
                    for (JmxEventListener l : this.jmxEventListeners) {
                        l.jmxDisabled();
                    }
                }
                this.instance.disableJMX();
            }
        }
    }

    public void addJmxEventListener(JmxEventListener listener) {
        if (listener != null) {
            this.jmxEventListeners.add(listener);
        }
    }

    public void removeJmxEventListener(JmxEventListener listener) {
        if (listener != null) {
            this.jmxEventListeners.remove(listener);
        }
    }

    public Set<JmxEventListener> getJmxEventListeners() {
        return this.jmxEventListeners;
    }

    public boolean isAllowPayloadForUndefinedHttpMethods() {
        return this.allowPayloadForUndefinedHttpMethods;
    }

    public void setAllowPayloadForUndefinedHttpMethods(boolean allowPayloadForUndefinedHttpMethods) {
        this.allowPayloadForUndefinedHttpMethods = allowPayloadForUndefinedHttpMethods;
    }

    public long getMaxPayloadRemainderToSkip() {
        return this.maxPayloadRemainderToSkip;
    }

    public void setMaxPayloadRemainderToSkip(long maxPayloadRemainderToSkip) {
        this.maxPayloadRemainderToSkip = maxPayloadRemainderToSkip;
    }
}

