/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.http.server.accesslog;

import com.pdd.pop.ext.glassfish.grizzly.http.server.HttpServerProbe;
import com.pdd.pop.ext.glassfish.grizzly.http.server.ServerConfiguration;
import com.pdd.pop.ext.glassfish.grizzly.http.server.accesslog.AccessLogAppender;
import com.pdd.pop.ext.glassfish.grizzly.http.server.accesslog.AccessLogFormat;
import com.pdd.pop.ext.glassfish.grizzly.http.server.accesslog.AccessLogProbe;
import com.pdd.pop.ext.glassfish.grizzly.http.server.accesslog.ApacheLogFormat;
import com.pdd.pop.ext.glassfish.grizzly.http.server.accesslog.FileAppender;
import com.pdd.pop.ext.glassfish.grizzly.http.server.accesslog.QueueingAppender;
import com.pdd.pop.ext.glassfish.grizzly.http.server.accesslog.RotatingFileAppender;
import java.io.File;
import java.io.IOException;
import java.util.TimeZone;

public class AccessLogBuilder {
    private AccessLogFormat format = ApacheLogFormat.COMBINED;
    private int statusThreshold = Integer.MIN_VALUE;
    private String rotationPattern;
    private boolean synchronous;
    private final File file;

    public AccessLogBuilder(String file) {
        if (file == null) {
            throw new NullPointerException("Null file");
        }
        this.file = new File(file).getAbsoluteFile();
    }

    public AccessLogBuilder(File file) {
        if (file == null) {
            throw new NullPointerException("Null file");
        }
        this.file = file;
    }

    public AccessLogProbe build() {
        AccessLogAppender appender;
        try {
            if (this.rotationPattern == null) {
                appender = new FileAppender(this.file.getCanonicalFile());
            } else {
                String extension;
                String base;
                File directory = this.file.getCanonicalFile().getParentFile();
                String name = this.file.getName();
                int position = name.lastIndexOf(".");
                if (position < 0) {
                    base = name.replace("'", "''");
                    extension = "";
                } else {
                    base = name.substring(0, position).replace("'", "''");
                    extension = name.substring(position).replace("'", "''");
                }
                String archive = '\'' + base + "'-" + this.rotationPattern + '\'' + extension + '\'';
                appender = new RotatingFileAppender(directory, name, archive);
            }
        }
        catch (IOException exception) {
            throw new IllegalStateException("I/O error creating acces log", exception);
        }
        if (!this.synchronous) {
            appender = new QueueingAppender(appender);
        }
        return new AccessLogProbe(appender, this.format, this.statusThreshold);
    }

    public ServerConfiguration instrument(ServerConfiguration serverConfiguration) {
        serverConfiguration.getMonitoringConfig().getWebServerConfig().addProbes((HttpServerProbe[])new HttpServerProbe[]{this.build()});
        return serverConfiguration;
    }

    public AccessLogBuilder format(AccessLogFormat format) {
        if (format == null) {
            throw new NullPointerException("Null format");
        }
        this.format = format;
        return this;
    }

    public AccessLogBuilder format(String format) {
        if (format == null) {
            throw new NullPointerException("Null format");
        }
        return this.format(new ApacheLogFormat(format));
    }

    public AccessLogBuilder timeZone(TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException("Null time zone");
        }
        if (this.format instanceof ApacheLogFormat) {
            ApacheLogFormat apacheFormat = (ApacheLogFormat)this.format;
            this.format = new ApacheLogFormat(timeZone, apacheFormat.getFormat());
            return this;
        }
        throw new IllegalStateException("TimeZone can not be set for " + this.format.getClass().getName());
    }

    public AccessLogBuilder timeZone(String timeZone) {
        if (timeZone == null) {
            throw new NullPointerException("Null time zone");
        }
        return this.timeZone(TimeZone.getTimeZone(timeZone));
    }

    public AccessLogBuilder statusThreshold(int statusThreshold) {
        this.statusThreshold = statusThreshold;
        return this;
    }

    public AccessLogBuilder rotatedHourly() {
        return this.rotationPattern("yyyyMMDDhh");
    }

    public AccessLogBuilder rotatedDaily() {
        return this.rotationPattern("yyyyMMDD");
    }

    public AccessLogBuilder rotationPattern(String rotationPattern) {
        if (rotationPattern == null) {
            throw new NullPointerException("Null rotation pattern");
        }
        this.rotationPattern = rotationPattern;
        return this;
    }

    public AccessLogBuilder synchronous(boolean synchronous) {
        this.synchronous = synchronous;
        return this;
    }
}

