/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.http.server.io;

import com.pdd.pop.ext.glassfish.grizzly.Buffer;
import com.pdd.pop.ext.glassfish.grizzly.filterchain.FilterChainContext;
import com.pdd.pop.ext.glassfish.grizzly.http.HttpBrokenContent;
import com.pdd.pop.ext.glassfish.grizzly.http.HttpContent;
import com.pdd.pop.ext.glassfish.grizzly.http.io.InputBuffer;
import com.pdd.pop.ext.glassfish.grizzly.http.server.Request;
import java.io.IOException;
import java.util.concurrent.Executor;

public class ServerInputBuffer
extends InputBuffer {
    private long totalReadContentInBytes;
    private Request serverRequest;

    public void initialize(Request serverRequest, FilterChainContext ctx) {
        this.serverRequest = serverRequest;
        super.initialize(serverRequest.getRequest(), ctx);
    }

    @Override
    public void initiateAsyncronousDataReceiving() {
        if (!this.checkChunkedMaxPostSize()) {
            HttpBrokenContent brokenContent = HttpBrokenContent.builder(this.serverRequest.getRequest()).error(new IOException("The HTTP request content exceeds max post size")).build();
            try {
                this.append(brokenContent);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        super.initiateAsyncronousDataReceiving();
    }

    @Override
    protected HttpContent blockingRead() throws IOException {
        if (!this.checkChunkedMaxPostSize()) {
            throw new IOException("The HTTP request content exceeds max post size");
        }
        return super.blockingRead();
    }

    @Override
    protected void updateInputContentBuffer(Buffer buffer) {
        this.totalReadContentInBytes += (long)buffer.remaining();
        super.updateInputContentBuffer(buffer);
    }

    @Override
    public void recycle() {
        this.serverRequest = null;
        this.totalReadContentInBytes = 0L;
        super.recycle();
    }

    @Override
    protected Executor getThreadPool() {
        return this.serverRequest.getRequestExecutor();
    }

    private boolean checkChunkedMaxPostSize() {
        if (this.serverRequest.getRequest().isChunked()) {
            long maxPostSize = this.serverRequest.getHttpFilter().getConfiguration().getMaxPostSize();
            return maxPostSize < 0L || maxPostSize > this.totalReadContentInBytes;
        }
        return true;
    }
}

