/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.http.server.util;

import com.pdd.pop.ext.glassfish.grizzly.Grizzly;
import com.pdd.pop.ext.glassfish.grizzly.GrizzlyFuture;
import com.pdd.pop.ext.glassfish.grizzly.http.server.Request;
import com.pdd.pop.ext.glassfish.grizzly.http.server.Response;
import com.pdd.pop.ext.glassfish.grizzly.localization.LogMessages;
import com.pdd.pop.ext.glassfish.grizzly.ssl.SSLBaseFilter;
import com.pdd.pop.ext.glassfish.grizzly.ssl.SSLSupportImpl;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RequestUtils {
    private static final Logger LOGGER = Grizzly.logger(RequestUtils.class);

    public static Object populateCertificateAttribute(Request request) {
        Object certificates = null;
        if (request.getRequest().isSecure()) {
            block6: {
                if (request.getRequest().getUpgradeDC().isNull()) {
                    try {
                        request.getInputBuffer().fillFully(request.getHttpFilter().getConfiguration().getMaxBufferedPostSize());
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Can't complete SSL re-negotation", e);
                    }
                }
                GrizzlyFuture<Object[]> certFuture = new SSLBaseFilter.CertificateEvent(true).trigger(request.getContext());
                try {
                    certificates = certFuture.get(30L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block6;
                    LOGGER.log(Level.FINE, "Unable to obtain certificates from peer.", e);
                }
            }
            request.setAttribute("javax.servlet.request.X509Certificate", certificates);
        }
        return certificates;
    }

    public static void populateSSLAttributes(Request request) {
        block7: {
            if (request.isSecure()) {
                try {
                    SSLSupportImpl sslSupport = new SSLSupportImpl(request.getContext().getConnection());
                    Object sslO = sslSupport.getCipherSuite();
                    if (sslO != null) {
                        request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                    }
                    if ((sslO = sslSupport.getPeerCertificateChain(false)) != null) {
                        request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                    }
                    if ((sslO = sslSupport.getKeySize()) != null) {
                        request.setAttribute("javax.servlet.request.key_size", sslO);
                    }
                    if ((sslO = sslSupport.getSessionId()) != null) {
                        request.setAttribute("javax.servlet.request.ssl_session_id", sslO);
                    }
                }
                catch (Exception ioe) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block7;
                    LOGGER.log(Level.FINE, "Unable to populate SSL attributes", ioe);
                }
            }
        }
    }

    public static void handleSendFile(Request request) {
        Object f = request.getAttribute("com.pdd.pop.ext.glassfish.grizzly.http.SEND_FILE");
        if (f != null) {
            Response response = request.getResponse();
            if (response.isCommitted()) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVER_REQUESTUTILS_SENDFILE_FAILED());
                }
                return;
            }
            File file = (File)f;
            Long offset = (Long)request.getAttribute("com.pdd.pop.ext.glassfish.grizzly.http.FILE_START_OFFSET");
            Long len = (Long)request.getAttribute("com.pdd.pop.ext.glassfish.grizzly.http.FILE_WRITE_LEN");
            if (offset == null) {
                offset = 0L;
            }
            if (len == null) {
                len = file.length();
            }
            response.getOutputBuffer().sendfile(file, offset, len, null);
        }
    }
}

