/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.http.util;

import com.pdd.pop.ext.glassfish.grizzly.Buffer;
import com.pdd.pop.ext.glassfish.grizzly.Grizzly;
import com.pdd.pop.ext.glassfish.grizzly.http.Cookies;
import com.pdd.pop.ext.glassfish.grizzly.http.util.Ascii;
import com.pdd.pop.ext.glassfish.grizzly.http.util.BufferChunk;
import com.pdd.pop.ext.glassfish.grizzly.http.util.ByteChunk;
import com.pdd.pop.ext.glassfish.grizzly.http.util.CharChunk;
import com.pdd.pop.ext.glassfish.grizzly.http.util.CookieUtils;
import com.pdd.pop.ext.glassfish.grizzly.http.util.DataChunk;
import com.pdd.pop.ext.glassfish.grizzly.utils.Charsets;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CookieParserUtils {
    private static final Logger LOGGER = Grizzly.logger(CookieParserUtils.class);

    public static void parseClientCookies(Cookies cookies, Buffer buffer, int off, int len) {
        CookieParserUtils.parseClientCookies(cookies, buffer, off, len, CookieUtils.COOKIE_VERSION_ONE_STRICT_COMPLIANCE, CookieUtils.RFC_6265_SUPPORT_ENABLED);
    }

    /*
     * Unable to fully structure code
     */
    public static void parseClientCookies(Cookies cookies, Buffer buffer, int off, int len, boolean versionOneStrictCompliance, boolean rfc6265Enabled) {
        if (cookies == null) {
            throw new IllegalArgumentException("cookies cannot be null.");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null.");
        }
        if (len <= 0) {
            return;
        }
        if (buffer.hasArray()) {
            CookieParserUtils.parseClientCookies(cookies, buffer.array(), off + buffer.arrayOffset(), len, versionOneStrictCompliance, rfc6265Enabled);
            return;
        }
        end = off + len;
        pos = off;
        version = 0;
        cookie = null;
        lazyCookie = null;
        while (pos < end) {
            block26: {
                block25: {
                    isSpecial = false;
                    isQuoted = false;
                    while (pos < end && (CookieUtils.isSeparator(buffer.get(pos)) || CookieUtils.isWhiteSpace(buffer.get(pos)))) {
                        ++pos;
                    }
                    if (pos >= end) {
                        return;
                    }
                    if (buffer.get(pos) == 36) {
                        isSpecial = true;
                    }
                    nameStart = ++pos;
                    for (pos = nameEnd = CookieUtils.getTokenEndPosition(buffer, pos, end); pos < end && CookieUtils.isWhiteSpace(buffer.get(pos)); ++pos) {
                    }
                    if (pos >= end || buffer.get(pos) != 61) break block25;
                    while (++pos < end && CookieUtils.isWhiteSpace(buffer.get(pos))) {
                    }
                    if (pos >= end) {
                        return;
                    }
                    switch (buffer.get(pos)) {
                        case 34: {
                            isQuoted = true;
                            valueStart = pos + 1;
                            pos = valueEnd = CookieUtils.getQuotedValueEndPosition(buffer, valueStart, end);
                            if (pos >= end) {
                                return;
                            }
                            break block26;
                        }
                        case 44: 
                        case 59: {
                            valueEnd = -1;
                            valueStart = -1;
                            break block26;
                        }
                        default: {
                            if (CookieUtils.isSeparator(buffer.get(pos), versionOneStrictCompliance)) ** GOTO lbl50
                            valueStart = pos;
                            pos = valueEnd = CookieUtils.getTokenEndPosition(buffer, valueStart, end, versionOneStrictCompliance);
                            break block26;
lbl50:
                            // 1 sources

                            CookieParserUtils.LOGGER.fine("Invalid cookie. Value not a token or quoted value");
                            while (pos < end && buffer.get(pos) != 59 && buffer.get(pos) != 44) {
                                ++pos;
                            }
                            ++pos;
                            cookie = null;
                            lazyCookie = null;
                            break;
                        }
                    }
                    continue;
                }
                valueEnd = -1;
                valueStart = -1;
                pos = nameEnd;
            }
            while (pos < end && CookieUtils.isWhiteSpace(buffer.get(pos))) {
                ++pos;
            }
            while (pos < end && buffer.get(pos) != 59 && buffer.get(pos) != 44) {
                ++pos;
            }
            ++pos;
            if (isSpecial) {
                isSpecial = false;
                if (CookieUtils.equals("Version", buffer, nameStart, nameEnd) && cookie == null) {
                    if (rfc6265Enabled || buffer.get(valueStart) != 49 || valueEnd != valueStart + 1) continue;
                    version = 1;
                    continue;
                }
                if (cookie == null) continue;
                if (CookieUtils.equals("Domain", buffer, nameStart, nameEnd)) {
                    lazyCookie.getDomain().setBuffer(buffer, valueStart, valueEnd);
                    continue;
                }
                if (CookieUtils.equals("Path", buffer, nameStart, nameEnd)) {
                    lazyCookie.getPath().setBuffer(buffer, valueStart, valueEnd);
                    continue;
                }
                CookieParserUtils.LOGGER.fine("Unknown Special Cookie");
                continue;
            }
            cookie = cookies.getNextUnusedCookie();
            lazyCookie = cookie.getLazyCookieState();
            if (!rfc6265Enabled && !cookie.isVersionSet()) {
                cookie.setVersion(version);
            }
            lazyCookie.getName().setBuffer(buffer, nameStart, nameEnd);
            if (valueStart != -1) {
                lazyCookie.getValue().setBuffer(buffer, valueStart, valueEnd);
                if (!isQuoted) continue;
                CookieParserUtils.unescapeDoubleQuotes(lazyCookie.getValue());
                continue;
            }
            lazyCookie.getValue().setString("");
        }
    }

    public static void parseClientCookies(Cookies cookies, byte[] bytes, int off, int len) {
        CookieParserUtils.parseClientCookies(cookies, bytes, off, len, CookieUtils.COOKIE_VERSION_ONE_STRICT_COMPLIANCE, false);
    }

    /*
     * Unable to fully structure code
     */
    public static void parseClientCookies(Cookies cookies, byte[] bytes, int off, int len, boolean versionOneStrictCompliance, boolean rfc6265Enabled) {
        if (cookies == null) {
            throw new IllegalArgumentException("cookies cannot be null.");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        if (len <= 0) {
            return;
        }
        end = off + len;
        pos = off;
        version = 0;
        cookie = null;
        lazyCookie = null;
        while (pos < end) {
            block25: {
                block24: {
                    isSpecial = false;
                    isQuoted = false;
                    while (pos < end && (CookieUtils.isSeparator(bytes[pos]) || CookieUtils.isWhiteSpace(bytes[pos]))) {
                        ++pos;
                    }
                    if (pos >= end) {
                        return;
                    }
                    if (bytes[pos] == 36) {
                        isSpecial = true;
                    }
                    nameStart = ++pos;
                    for (pos = nameEnd = CookieUtils.getTokenEndPosition(bytes, pos, end); pos < end && CookieUtils.isWhiteSpace(bytes[pos]); ++pos) {
                    }
                    if (pos >= end || bytes[pos] != 61) break block24;
                    while (++pos < end && CookieUtils.isWhiteSpace(bytes[pos])) {
                    }
                    if (pos >= end) {
                        return;
                    }
                    switch (bytes[pos]) {
                        case 34: {
                            isQuoted = true;
                            valueStart = pos + 1;
                            pos = valueEnd = CookieUtils.getQuotedValueEndPosition(bytes, valueStart, end);
                            if (pos >= end) {
                                return;
                            }
                            break block25;
                        }
                        case 44: 
                        case 59: {
                            valueEnd = -1;
                            valueStart = -1;
                            break block25;
                        }
                        default: {
                            if (CookieUtils.isSeparator(bytes[pos], versionOneStrictCompliance)) ** GOTO lbl47
                            valueStart = pos;
                            pos = valueEnd = CookieUtils.getTokenEndPosition(bytes, valueStart, end, versionOneStrictCompliance);
                            break block25;
lbl47:
                            // 1 sources

                            CookieParserUtils.LOGGER.fine("Invalid cookie. Value not a token or quoted value");
                            while (pos < end && bytes[pos] != 59 && bytes[pos] != 44) {
                                ++pos;
                            }
                            ++pos;
                            cookie = null;
                            lazyCookie = null;
                            break;
                        }
                    }
                    continue;
                }
                valueEnd = -1;
                valueStart = -1;
                pos = nameEnd;
            }
            while (pos < end && CookieUtils.isWhiteSpace(bytes[pos])) {
                ++pos;
            }
            while (pos < end && bytes[pos] != 59 && bytes[pos] != 44) {
                ++pos;
            }
            ++pos;
            if (isSpecial) {
                isSpecial = false;
                if (CookieUtils.equals("Version", bytes, nameStart, nameEnd) && cookie == null) {
                    if (rfc6265Enabled || bytes[valueStart] != 49 || valueEnd != valueStart + 1) continue;
                    version = 1;
                    continue;
                }
                if (cookie == null) continue;
                if (CookieUtils.equals("Domain", bytes, nameStart, nameEnd)) {
                    lazyCookie.getDomain().setBytes(bytes, valueStart, valueEnd);
                    continue;
                }
                if (CookieUtils.equals("Path", bytes, nameStart, nameEnd)) {
                    lazyCookie.getPath().setBytes(bytes, valueStart, valueEnd);
                    continue;
                }
                CookieParserUtils.LOGGER.fine("Unknown Special Cookie");
                continue;
            }
            cookie = cookies.getNextUnusedCookie();
            lazyCookie = cookie.getLazyCookieState();
            if (!rfc6265Enabled && !cookie.isVersionSet()) {
                cookie.setVersion(version);
            }
            lazyCookie.getName().setBytes(bytes, nameStart, nameEnd);
            if (valueStart != -1) {
                lazyCookie.getValue().setBytes(bytes, valueStart, valueEnd);
                if (!isQuoted) continue;
                CookieParserUtils.unescapeDoubleQuotes(lazyCookie.getValue());
                continue;
            }
            lazyCookie.getValue().setString("");
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void parseClientCookies(Cookies cookies, String cookiesStr, boolean versionOneStrictCompliance, boolean rfc6265Enabled) {
        if (cookies == null) {
            throw new IllegalArgumentException("cookies cannot be null.");
        }
        if (cookiesStr == null) {
            throw new IllegalArgumentException("cookieStr cannot be null.");
        }
        if (cookiesStr.length() == 0) {
            return;
        }
        end = cookiesStr.length();
        pos = 0;
        version = 0;
        cookie = null;
        while (pos < end) {
            block23: {
                block22: {
                    isSpecial = false;
                    isQuoted = false;
                    while (pos < end && (CookieUtils.isSeparator(cookiesStr.charAt(pos)) || CookieUtils.isWhiteSpace(cookiesStr.charAt(pos)))) {
                        ++pos;
                    }
                    if (pos >= end) {
                        return;
                    }
                    if (cookiesStr.charAt(pos) == '$') {
                        isSpecial = true;
                    }
                    nameStart = ++pos;
                    for (pos = nameEnd = CookieUtils.getTokenEndPosition(cookiesStr, pos, end); pos < end && CookieUtils.isWhiteSpace(cookiesStr.charAt(pos)); ++pos) {
                    }
                    if (pos >= end || cookiesStr.charAt(pos) != '=') break block22;
                    while (++pos < end && CookieUtils.isWhiteSpace(cookiesStr.charAt(pos))) {
                    }
                    if (pos >= end) {
                        return;
                    }
                    switch (cookiesStr.charAt(pos)) {
                        case '\"': {
                            isQuoted = true;
                            valueStart = pos + 1;
                            pos = valueEnd = CookieUtils.getQuotedValueEndPosition(cookiesStr, valueStart, end);
                            if (pos >= end) {
                                return;
                            }
                            break block23;
                        }
                        case ',': 
                        case ';': {
                            valueEnd = -1;
                            valueStart = -1;
                            break block23;
                        }
                        default: {
                            if (CookieUtils.isSeparator(cookiesStr.charAt(pos), versionOneStrictCompliance)) ** GOTO lbl46
                            valueStart = pos;
                            pos = valueEnd = CookieUtils.getTokenEndPosition(cookiesStr, valueStart, end, versionOneStrictCompliance);
                            break block23;
lbl46:
                            // 1 sources

                            CookieParserUtils.LOGGER.fine("Invalid cookie. Value not a token or quoted value");
                            while (pos < end && cookiesStr.charAt(pos) != ';' && cookiesStr.charAt(pos) != ',') {
                                ++pos;
                            }
                            ++pos;
                            cookie = null;
                            break;
                        }
                    }
                    continue;
                }
                valueEnd = -1;
                valueStart = -1;
                pos = nameEnd;
            }
            while (pos < end && CookieUtils.isWhiteSpace(cookiesStr.charAt(pos))) {
                ++pos;
            }
            while (pos < end && cookiesStr.charAt(pos) != ';' && cookiesStr.charAt(pos) != ',') {
                ++pos;
            }
            ++pos;
            if (isSpecial) {
                isSpecial = false;
                if (CookieUtils.equals("Version", cookiesStr, nameStart, nameEnd) && cookie == null) {
                    if (rfc6265Enabled || cookiesStr.charAt(valueStart) != '1' || valueEnd != valueStart + 1) continue;
                    version = 1;
                    continue;
                }
                if (cookie == null) continue;
                if (CookieUtils.equals("Domain", cookiesStr, nameStart, nameEnd)) {
                    cookie.setDomain(cookiesStr.substring(valueStart, valueEnd));
                    continue;
                }
                if (CookieUtils.equals("Path", cookiesStr, nameStart, nameEnd)) {
                    cookie.setPath(cookiesStr.substring(valueStart, valueEnd));
                    continue;
                }
                CookieParserUtils.LOGGER.fine("Unknown Special Cookie");
                continue;
            }
            name = cookiesStr.substring(nameStart, nameEnd);
            value = valueStart != -1 ? (isQuoted ? CookieParserUtils.unescapeDoubleQuotes(cookiesStr, valueStart, valueEnd - valueStart) : cookiesStr.substring(valueStart, valueEnd)) : "";
            cookie = cookies.getNextUnusedCookie();
            cookie.setName(name);
            cookie.setValue(value);
            if (rfc6265Enabled || cookie.isVersionSet()) continue;
            cookie.setVersion(version);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void parseServerCookies(Cookies cookies, byte[] bytes, int off, int len, boolean versionOneStrictCompliance, boolean rfc6265Enabled) {
        if (cookies == null) {
            throw new IllegalArgumentException("cookies cannot be null.");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        if (len <= 0) {
            return;
        }
        end = off + len;
        pos = off;
        cookie = null;
        lazyCookie = null;
        while (pos < end) {
            block31: {
                block30: {
                    isQuoted = false;
                    while (pos < end && (CookieUtils.isSeparator(bytes[pos]) || CookieUtils.isWhiteSpace(bytes[pos]))) {
                        ++pos;
                    }
                    if (pos >= end) {
                        return;
                    }
                    nameStart = pos;
                    for (pos = nameEnd = CookieUtils.getTokenEndPosition(bytes, pos, end); pos < end && CookieUtils.isWhiteSpace(bytes[pos]); ++pos) {
                    }
                    if (pos >= end || bytes[pos] != 61) break block30;
                    while (++pos < end && CookieUtils.isWhiteSpace(bytes[pos])) {
                    }
                    if (pos >= end) {
                        return;
                    }
                    switch (bytes[pos]) {
                        case 34: {
                            isQuoted = true;
                            valueStart = pos + 1;
                            pos = valueEnd = CookieUtils.getQuotedValueEndPosition(bytes, valueStart, end);
                            if (pos >= end) {
                                return;
                            }
                            break block31;
                        }
                        case 44: 
                        case 59: {
                            valueEnd = -1;
                            valueStart = -1;
                            break block31;
                        }
                        default: {
                            if (CookieUtils.isSeparator(bytes[pos], versionOneStrictCompliance)) ** GOTO lbl43
                            valueStart = pos;
                            pos = valueEnd = CookieUtils.getTokenEndPosition(bytes, valueStart, end, versionOneStrictCompliance);
                            break block31;
lbl43:
                            // 1 sources

                            CookieParserUtils.LOGGER.fine("Invalid cookie. Value not a token or quoted value");
                            while (pos < end && bytes[pos] != 59 && bytes[pos] != 44) {
                                ++pos;
                            }
                            ++pos;
                            cookie = null;
                            lazyCookie = null;
                            break;
                        }
                    }
                    continue;
                }
                valueEnd = -1;
                valueStart = -1;
                pos = nameEnd;
            }
            while (pos < end && CookieUtils.isWhiteSpace(bytes[pos])) {
                ++pos;
            }
            while (pos < end && bytes[pos] != 59 && bytes[pos] != 44) {
                ++pos;
            }
            ++pos;
            if (cookie != null) {
                if (lazyCookie.getDomain().isNull() && CookieUtils.equalsIgnoreCase("Domain", bytes, nameStart, nameEnd)) {
                    lazyCookie.getDomain().setBytes(bytes, valueStart, valueEnd);
                    continue;
                }
                if (lazyCookie.getPath().isNull() && CookieUtils.equalsIgnoreCase("Path", bytes, nameStart, nameEnd)) {
                    lazyCookie.getPath().setBytes(bytes, valueStart, valueEnd);
                    continue;
                }
                if (CookieUtils.equals("Version", bytes, nameStart, nameEnd)) {
                    if (rfc6265Enabled || bytes[valueStart] != 49 || valueEnd != valueStart + 1) continue;
                    cookie.setVersion(1);
                    continue;
                }
                if (lazyCookie.getComment().isNull() && CookieUtils.equals("Comment", bytes, nameStart, nameEnd)) {
                    lazyCookie.getComment().setBytes(bytes, valueStart, valueEnd);
                    continue;
                }
                if (cookie.getMaxAge() == -1 && CookieUtils.equals("Max-Age", bytes, nameStart, nameEnd)) {
                    cookie.setMaxAge(Ascii.parseInt(bytes, valueStart, valueEnd - valueStart));
                    continue;
                }
                if ((cookie.getVersion() == 0 || !cookie.isVersionSet()) && cookie.getMaxAge() == -1 && CookieUtils.equalsIgnoreCase("Expires", bytes, nameStart, nameEnd)) {
                    try {
                        valueEnd = CookieUtils.getTokenEndPosition(bytes, valueEnd + 1, end, false);
                        pos = valueEnd + 1;
                        expiresDate = new String(bytes, valueStart, valueEnd - valueStart, Charsets.ASCII_CHARSET);
                        date = CookieUtils.OLD_COOKIE_FORMAT.get().parse(expiresDate);
                        cookie.setMaxAge(CookieParserUtils.getMaxAgeDelta(date.getTime(), System.currentTimeMillis()) / 1000);
                    }
                    catch (ParseException ignore) {}
                    continue;
                }
                if (!cookie.isSecure() && CookieUtils.equalsIgnoreCase("Secure", bytes, nameStart, nameEnd)) {
                    lazyCookie.setSecure(true);
                    continue;
                }
                if (!cookie.isHttpOnly() && CookieUtils.equals("HttpOnly", bytes, nameStart, nameEnd)) {
                    cookie.setHttpOnly(true);
                    continue;
                }
                if (CookieUtils.equals("Discard", bytes, nameStart, nameEnd)) continue;
            }
            cookie = cookies.getNextUnusedCookie();
            if (!rfc6265Enabled && !cookie.isVersionSet()) {
                cookie.setVersion(0);
            }
            lazyCookie = cookie.getLazyCookieState();
            lazyCookie.getName().setBytes(bytes, nameStart, nameEnd);
            if (valueStart != -1) {
                lazyCookie.getValue().setBytes(bytes, valueStart, valueEnd);
                if (!isQuoted) continue;
                CookieParserUtils.unescapeDoubleQuotes(lazyCookie.getValue());
                continue;
            }
            lazyCookie.getValue().setString("");
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void parseServerCookies(Cookies cookies, Buffer buffer, int off, int len, boolean versionOneStrictCompliance, boolean rfc6265Enabled) {
        if (cookies == null) {
            throw new IllegalArgumentException("cookies cannot be null.");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null.");
        }
        if (len <= 0) {
            return;
        }
        if (buffer.hasArray()) {
            CookieParserUtils.parseServerCookies(cookies, buffer.array(), off + buffer.arrayOffset(), len, versionOneStrictCompliance, rfc6265Enabled);
            return;
        }
        end = off + len;
        pos = off;
        cookie = null;
        lazyCookie = null;
        while (pos < end) {
            block32: {
                block31: {
                    isQuoted = false;
                    while (pos < end && (CookieUtils.isSeparator(buffer.get(pos)) || CookieUtils.isWhiteSpace(buffer.get(pos)))) {
                        ++pos;
                    }
                    if (pos >= end) {
                        return;
                    }
                    nameStart = pos;
                    for (pos = nameEnd = CookieUtils.getTokenEndPosition(buffer, pos, end); pos < end && CookieUtils.isWhiteSpace(buffer.get(pos)); ++pos) {
                    }
                    if (pos >= end || buffer.get(pos) != 61) break block31;
                    while (++pos < end && CookieUtils.isWhiteSpace(buffer.get(pos))) {
                    }
                    if (pos >= end) {
                        return;
                    }
                    switch (buffer.get(pos)) {
                        case 34: {
                            isQuoted = true;
                            valueStart = pos + 1;
                            pos = valueEnd = CookieUtils.getQuotedValueEndPosition(buffer, valueStart, end);
                            if (pos >= end) {
                                return;
                            }
                            break block32;
                        }
                        case 44: 
                        case 59: {
                            valueEnd = -1;
                            valueStart = -1;
                            break block32;
                        }
                        default: {
                            if (CookieUtils.isSeparator(buffer.get(pos), versionOneStrictCompliance)) ** GOTO lbl46
                            valueStart = pos;
                            pos = valueEnd = CookieUtils.getTokenEndPosition(buffer, valueStart, end, versionOneStrictCompliance);
                            break block32;
lbl46:
                            // 1 sources

                            CookieParserUtils.LOGGER.fine("Invalid cookie. Value not a token or quoted value");
                            while (pos < end && buffer.get(pos) != 59 && buffer.get(pos) != 44) {
                                ++pos;
                            }
                            ++pos;
                            cookie = null;
                            lazyCookie = null;
                            break;
                        }
                    }
                    continue;
                }
                valueEnd = -1;
                valueStart = -1;
                pos = nameEnd;
            }
            while (pos < end && CookieUtils.isWhiteSpace(buffer.get(pos))) {
                ++pos;
            }
            while (pos < end && buffer.get(pos) != 59 && buffer.get(pos) != 44) {
                ++pos;
            }
            ++pos;
            if (cookie != null) {
                if (lazyCookie.getDomain().isNull() && CookieUtils.equalsIgnoreCase("Domain", buffer, nameStart, nameEnd)) {
                    lazyCookie.getDomain().setBuffer(buffer, valueStart, valueEnd);
                    continue;
                }
                if (lazyCookie.getPath().isNull() && CookieUtils.equalsIgnoreCase("Path", buffer, nameStart, nameEnd)) {
                    lazyCookie.getPath().setBuffer(buffer, valueStart, valueEnd);
                    continue;
                }
                if (CookieUtils.equals("Version", buffer, nameStart, nameEnd)) {
                    if (rfc6265Enabled || buffer.get(valueStart) != 49 || valueEnd != valueStart + 1) continue;
                    cookie.setVersion(1);
                    continue;
                }
                if (lazyCookie.getComment().isNull() && CookieUtils.equals("Comment", buffer, nameStart, nameEnd)) {
                    lazyCookie.getComment().setBuffer(buffer, valueStart, valueEnd);
                    continue;
                }
                if (cookie.getMaxAge() == -1 && CookieUtils.equals("Max-Age", buffer, nameStart, nameEnd)) {
                    cookie.setMaxAge(Ascii.parseInt(buffer, valueStart, valueEnd - valueStart));
                    continue;
                }
                if ((cookie.getVersion() == 0 || !cookie.isVersionSet()) && cookie.getMaxAge() == -1 && CookieUtils.equalsIgnoreCase("Expires", buffer, nameStart, nameEnd)) {
                    try {
                        valueEnd = CookieUtils.getTokenEndPosition(buffer, valueEnd + 1, end, false);
                        pos = valueEnd + 1;
                        expiresDate = buffer.toStringContent(Charsets.ASCII_CHARSET, valueStart, valueEnd);
                        date = CookieUtils.OLD_COOKIE_FORMAT.get().parse(expiresDate);
                        cookie.setMaxAge(CookieParserUtils.getMaxAgeDelta(date.getTime(), System.currentTimeMillis()) / 1000);
                    }
                    catch (ParseException ignore) {}
                    continue;
                }
                if (!cookie.isSecure() && CookieUtils.equalsIgnoreCase("Secure", buffer, nameStart, nameEnd)) {
                    lazyCookie.setSecure(true);
                    continue;
                }
                if (!cookie.isHttpOnly() && CookieUtils.equals("HttpOnly", buffer, nameStart, nameEnd)) {
                    cookie.setHttpOnly(true);
                    continue;
                }
                if (CookieUtils.equals("Discard", buffer, nameStart, nameEnd)) continue;
            }
            cookie = cookies.getNextUnusedCookie();
            if (!rfc6265Enabled && !cookie.isVersionSet()) {
                cookie.setVersion(0);
            }
            lazyCookie = cookie.getLazyCookieState();
            lazyCookie.getName().setBuffer(buffer, nameStart, nameEnd);
            if (valueStart != -1) {
                lazyCookie.getValue().setBuffer(buffer, valueStart, valueEnd);
                if (!isQuoted) continue;
                CookieParserUtils.unescapeDoubleQuotes(lazyCookie.getValue());
                continue;
            }
            lazyCookie.getValue().setString("");
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void parseServerCookies(Cookies cookies, String cookiesStr, boolean versionOneStrictCompliance, boolean rfc6265Enabled) {
        if (cookies == null) {
            throw new IllegalArgumentException("cookies cannot be null.");
        }
        if (cookiesStr == null) {
            throw new IllegalArgumentException();
        }
        if (cookiesStr.length() == 0) {
            return;
        }
        end = cookiesStr.length();
        pos = 0;
        cookie = null;
        while (pos < end) {
            block31: {
                block30: {
                    isQuoted = false;
                    while (pos < end && (CookieUtils.isSeparator(cookiesStr.charAt(pos)) || CookieUtils.isWhiteSpace(cookiesStr.charAt(pos)))) {
                        ++pos;
                    }
                    if (pos >= end) {
                        return;
                    }
                    nameStart = pos;
                    for (pos = nameEnd = CookieUtils.getTokenEndPosition(cookiesStr, pos, end); pos < end && CookieUtils.isWhiteSpace(cookiesStr.charAt(pos)); ++pos) {
                    }
                    if (pos >= end || cookiesStr.charAt(pos) != '=') break block30;
                    while (++pos < end && CookieUtils.isWhiteSpace(cookiesStr.charAt(pos))) {
                    }
                    if (pos >= end) {
                        return;
                    }
                    switch (cookiesStr.charAt(pos)) {
                        case '\"': {
                            isQuoted = true;
                            valueStart = pos + 1;
                            pos = valueEnd = CookieUtils.getQuotedValueEndPosition(cookiesStr, valueStart, end);
                            if (pos >= end) {
                                return;
                            }
                            break block31;
                        }
                        case ',': 
                        case ';': {
                            valueEnd = -1;
                            valueStart = -1;
                            break block31;
                        }
                        default: {
                            if (CookieUtils.isSeparator(cookiesStr.charAt(pos), versionOneStrictCompliance)) ** GOTO lbl42
                            valueStart = pos;
                            pos = valueEnd = CookieUtils.getTokenEndPosition(cookiesStr, valueStart, end, versionOneStrictCompliance);
                            break block31;
lbl42:
                            // 1 sources

                            CookieParserUtils.LOGGER.fine("Invalid cookie. Value not a token or quoted value");
                            while (pos < end && cookiesStr.charAt(pos) != ';' && cookiesStr.charAt(pos) != ',') {
                                ++pos;
                            }
                            ++pos;
                            cookie = null;
                            break;
                        }
                    }
                    continue;
                }
                valueEnd = -1;
                valueStart = -1;
                pos = nameEnd;
            }
            while (pos < end && CookieUtils.isWhiteSpace(cookiesStr.charAt(pos))) {
                ++pos;
            }
            while (pos < end && cookiesStr.charAt(pos) != ';' && cookiesStr.charAt(pos) != ',') {
                ++pos;
            }
            ++pos;
            if (cookie != null) {
                if (cookie.getDomain() == null && CookieUtils.equalsIgnoreCase("Domain", cookiesStr, nameStart, nameEnd)) {
                    cookie.setDomain(cookiesStr.substring(valueStart, valueEnd));
                    continue;
                }
                if (cookie.getPath() == null && CookieUtils.equalsIgnoreCase("Path", cookiesStr, nameStart, nameEnd)) {
                    cookie.setPath(cookiesStr.substring(valueStart, valueEnd));
                    continue;
                }
                if (CookieUtils.equals("Version", cookiesStr, nameStart, nameEnd)) {
                    if (rfc6265Enabled) continue;
                    if (cookiesStr.charAt(valueStart) == '1' && valueEnd == valueStart + 1) {
                        cookie.setVersion(1);
                        continue;
                    }
                    if (rfc6265Enabled) continue;
                    cookie.setVersion(0);
                    continue;
                }
                if (cookie.getComment() == null && CookieUtils.equals("Comment", cookiesStr, nameStart, nameEnd)) {
                    cookie.setComment(cookiesStr.substring(valueStart, valueEnd));
                    continue;
                }
                if (cookie.getMaxAge() == -1 && CookieUtils.equals("Max-Age", cookiesStr, nameStart, nameEnd)) {
                    cookie.setMaxAge(Integer.parseInt(cookiesStr.substring(valueStart, valueEnd)));
                    continue;
                }
                if ((cookie.getVersion() == 0 || cookie.isVersionSet()) && cookie.getMaxAge() == -1 && CookieUtils.equalsIgnoreCase("Expires", cookiesStr, nameStart, nameEnd)) {
                    try {
                        valueEnd = CookieUtils.getTokenEndPosition(cookiesStr, valueEnd + 1, end, false);
                        pos = valueEnd + 1;
                        expiresDate = cookiesStr.substring(valueStart, valueEnd);
                        date = CookieUtils.OLD_COOKIE_FORMAT.get().parse(expiresDate);
                        cookie.setMaxAge(CookieParserUtils.getMaxAgeDelta(date.getTime(), System.currentTimeMillis()) / 1000);
                    }
                    catch (ParseException ignore) {}
                    continue;
                }
                if (!cookie.isSecure() && CookieUtils.equalsIgnoreCase("Secure", cookiesStr, nameStart, nameEnd)) {
                    cookie.setSecure(true);
                    continue;
                }
                if (!cookie.isHttpOnly() && CookieUtils.equals("HttpOnly", cookiesStr, nameStart, nameEnd)) {
                    cookie.setHttpOnly(true);
                    continue;
                }
                if (CookieUtils.equals("Discard", cookiesStr, nameStart, nameEnd)) continue;
            }
            name = cookiesStr.substring(nameStart, nameEnd);
            value = valueStart != -1 ? (isQuoted ? CookieParserUtils.unescapeDoubleQuotes(cookiesStr, valueStart, valueEnd - valueStart) : cookiesStr.substring(valueStart, valueEnd)) : "";
            cookie = cookies.getNextUnusedCookie();
            if (!rfc6265Enabled && !cookie.isVersionSet()) {
                cookie.setVersion(0);
            }
            cookie.setName(name);
            cookie.setValue(value);
        }
    }

    public static void unescapeDoubleQuotes(DataChunk dc) {
        switch (dc.getType()) {
            case Bytes: {
                CookieParserUtils.unescapeDoubleQuotes(dc.getByteChunk());
                return;
            }
            case Buffer: {
                CookieParserUtils.unescapeDoubleQuotes(dc.getBufferChunk());
                return;
            }
            case String: {
                String s = dc.toString();
                dc.setString(CookieParserUtils.unescapeDoubleQuotes(s, 0, s.length()));
                return;
            }
        }
        throw new NullPointerException();
    }

    public static void unescapeDoubleQuotes(ByteChunk bc) {
        int src;
        if (bc == null || bc.getLength() == 0) {
            return;
        }
        int end = bc.getEnd();
        int dest = src;
        byte[] buffer = bc.getBuffer();
        for (src = bc.getStart(); src < end; ++src) {
            if (buffer[src] == 92 && src < end && buffer[src + 1] == 34) {
                ++src;
            }
            buffer[dest] = buffer[src];
            ++dest;
        }
        bc.setEnd(dest);
    }

    public static void unescapeDoubleQuotes(BufferChunk bc) {
        int src;
        if (bc == null || bc.getLength() == 0) {
            return;
        }
        int end = bc.getEnd();
        int dest = src;
        Buffer buffer = bc.getBuffer();
        for (src = bc.getStart(); src < end; ++src) {
            if (buffer.get(src) == 92 && src < end && buffer.get(src + 1) == 34) {
                ++src;
            }
            buffer.put(dest, buffer.get(src));
            ++dest;
        }
        bc.setEnd(dest);
    }

    public static void unescapeDoubleQuotes(CharChunk cc) {
        int src;
        if (cc == null || cc.getLength() == 0) {
            return;
        }
        int end = cc.getLimit();
        int dest = src;
        char[] buffer = cc.getBuffer();
        for (src = cc.getStart(); src < end; ++src) {
            if (buffer[src] == '\\' && src < end && buffer[src + 1] == '\"') {
                ++src;
            }
            buffer[dest] = buffer[src];
            ++dest;
        }
        cc.setLimit(dest);
    }

    public static int unescapeDoubleQuotes(Buffer buffer, int start, int length) {
        int src;
        if (buffer == null || length <= 0) {
            return length;
        }
        int end = src + length;
        int dest = src;
        for (src = start; src < end; ++src) {
            if (buffer.get(src) == 92 && src < end && buffer.get(src + 1) == 34) {
                ++src;
            }
            buffer.put(dest, buffer.get(src));
            ++dest;
        }
        return dest - start;
    }

    public static String unescapeDoubleQuotes(String s, int start, int length) {
        int src;
        if (s == null || s.length() == 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        int end = src + length;
        for (src = start; src < end; ++src) {
            if (s.charAt(src) == '\\' && src < end && s.charAt(src + 1) == '\"') {
                ++src;
            }
            sb.append(s.charAt(src));
        }
        return sb.toString();
    }

    private static int getMaxAgeDelta(long date1, long date2) {
        long result = date1 - date2;
        if (result > Integer.MAX_VALUE) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Integer overflow when calculating max age delta.  Date: " + date1 + ", current date: " + date2 + ".  Using Integer.MAX_VALUE for further calculation.");
            }
            return Integer.MAX_VALUE;
        }
        return (int)result;
    }
}

