/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.http.util;

import com.pdd.pop.ext.glassfish.grizzly.http.util.DataChunk;
import com.pdd.pop.ext.glassfish.grizzly.http.util.HttpCodecUtils;

public final class HeaderValue {
    public static final HeaderValue IDENTITY = HeaderValue.newHeaderValue("identity").prepare();
    private final String value;
    private byte[] preparedByteArray;

    public static HeaderValue newHeaderValue(String value) {
        return new HeaderValue(value);
    }

    private HeaderValue(String value) {
        this.value = value;
    }

    public HeaderValue prepare() {
        if (this.preparedByteArray == null) {
            this.getByteArray();
        }
        return this;
    }

    public boolean isSet() {
        return this.value != null;
    }

    public String get() {
        return this.value;
    }

    public byte[] getByteArray() {
        if (this.preparedByteArray != null) {
            return this.preparedByteArray;
        }
        if (this.value == null) {
            return HttpCodecUtils.EMPTY_ARRAY;
        }
        this.preparedByteArray = HttpCodecUtils.toCheckedByteArray(this.value);
        return this.preparedByteArray;
    }

    public String toString() {
        return this.value;
    }

    public void serializeToDataChunk(DataChunk dc) {
        if (this.preparedByteArray != null) {
            dc.setBytes(this.preparedByteArray);
        } else {
            dc.setString(this.value);
        }
    }
}

