/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.impl;

import com.pdd.pop.ext.glassfish.grizzly.Cacheable;
import com.pdd.pop.ext.glassfish.grizzly.CompletionHandler;
import com.pdd.pop.ext.glassfish.grizzly.ThreadCache;
import com.pdd.pop.ext.glassfish.grizzly.impl.FutureImpl;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class UnsafeFutureImpl<R>
implements FutureImpl<R> {
    private static final ThreadCache.CachedTypeIndex<UnsafeFutureImpl> CACHE_IDX = ThreadCache.obtainIndex(UnsafeFutureImpl.class, 4);
    protected boolean isDone;
    protected boolean isCancelled;
    protected Throwable failure;
    protected Set<CompletionHandler<R>> completionHandlers;
    protected R result;
    protected int recycleMark;

    public static <R> UnsafeFutureImpl<R> create() {
        UnsafeFutureImpl future = ThreadCache.takeFromCache(CACHE_IDX);
        if (future != null) {
            return future;
        }
        return new UnsafeFutureImpl<R>();
    }

    private UnsafeFutureImpl() {
    }

    @Override
    public void addCompletionHandler(CompletionHandler<R> completionHandler) {
        if (this.isDone) {
            this.notifyCompletionHandler(completionHandler);
        } else {
            if (this.completionHandlers == null) {
                this.completionHandlers = new HashSet<CompletionHandler<R>>(2);
            }
            this.completionHandlers.add(completionHandler);
        }
    }

    @Override
    public R getResult() {
        return this.result;
    }

    @Override
    public void result(R result) {
        this.result = result;
        this.notifyHaveResult();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.isCancelled = true;
        this.notifyHaveResult();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        if (this.isDone) {
            if (this.isCancelled) {
                throw new CancellationException();
            }
            if (this.failure != null) {
                throw new ExecutionException(this.failure);
            }
            if (this.result != null) {
                return this.result;
            }
        }
        throw new ExecutionException(new IllegalStateException("Result is not ready"));
    }

    @Override
    public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.get();
    }

    @Override
    public void failure(Throwable failure) {
        this.failure = failure;
        this.notifyHaveResult();
    }

    protected void notifyHaveResult() {
        if (this.recycleMark == 0) {
            this.isDone = true;
            this.notifyCompletionHandlers();
        } else {
            this.recycle(this.recycleMark == 2);
        }
    }

    private void notifyCompletionHandlers() {
        if (this.completionHandlers != null) {
            for (CompletionHandler<R> completionHandler : this.completionHandlers) {
                this.notifyCompletionHandler(completionHandler);
            }
            this.completionHandlers = null;
        }
    }

    private void notifyCompletionHandler(CompletionHandler<R> completionHandler) {
        try {
            if (this.isCancelled) {
                completionHandler.cancelled();
            } else if (this.failure != null) {
                completionHandler.failed(this.failure);
            } else if (this.result != null) {
                completionHandler.completed(this.result);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void markForRecycle(boolean recycleResult) {
        if (this.isDone) {
            this.recycle(recycleResult);
        } else {
            this.recycleMark = 1 + (recycleResult ? 1 : 0);
        }
    }

    protected void reset() {
        this.completionHandlers = null;
        this.result = null;
        this.failure = null;
        this.isCancelled = false;
        this.isDone = false;
        this.recycleMark = 0;
    }

    @Override
    public void recycle(boolean recycleResult) {
        if (recycleResult && this.result != null && this.result instanceof Cacheable) {
            ((Cacheable)this.result).recycle();
        }
        this.reset();
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    @Override
    public void recycle() {
        this.recycle(false);
    }
}

