/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.memory;

import com.pdd.pop.ext.glassfish.grizzly.Buffer;
import com.pdd.pop.ext.glassfish.grizzly.Cacheable;
import com.pdd.pop.ext.glassfish.grizzly.memory.MemoryManager;
import com.pdd.pop.ext.glassfish.grizzly.memory.MemoryProbe;
import com.pdd.pop.ext.glassfish.grizzly.memory.ProbeNotifier;
import com.pdd.pop.ext.glassfish.grizzly.memory.ThreadLocalPool;
import com.pdd.pop.ext.glassfish.grizzly.memory.ThreadLocalPoolProvider;
import com.pdd.pop.ext.glassfish.grizzly.monitoring.DefaultMonitoringConfig;
import com.pdd.pop.ext.glassfish.grizzly.threadpool.DefaultWorkerThread;

public abstract class AbstractMemoryManager<E extends Buffer>
implements MemoryManager<E>,
ThreadLocalPoolProvider {
    public static final int DEFAULT_MAX_BUFFER_SIZE = 65536;
    protected final DefaultMonitoringConfig<MemoryProbe> monitoringConfig = new DefaultMonitoringConfig<MemoryProbe>(MemoryProbe.class){

        @Override
        public Object createManagementObject() {
            return AbstractMemoryManager.this.createJmxManagementObject();
        }
    };
    protected final int maxBufferSize;

    public AbstractMemoryManager() {
        this(65536);
    }

    public AbstractMemoryManager(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    public int getReadyThreadBufferSize() {
        ThreadLocalPool threadLocalPool = AbstractMemoryManager.getThreadLocalPool();
        if (threadLocalPool != null) {
            return threadLocalPool.remaining();
        }
        return 0;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    protected Object allocateFromPool(ThreadLocalPool threadLocalCache, int size) {
        if (threadLocalCache.remaining() >= size) {
            ProbeNotifier.notifyBufferAllocatedFromPool(this.monitoringConfig, size);
            return threadLocalCache.allocate(size);
        }
        return null;
    }

    protected abstract Object createJmxManagementObject();

    protected static ThreadLocalPool getThreadLocalPool() {
        Thread t = Thread.currentThread();
        if (t instanceof DefaultWorkerThread) {
            return ((DefaultWorkerThread)t).getMemoryPool();
        }
        return null;
    }

    protected static interface TrimAware
    extends Cacheable {
    }
}

