/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.memory;

class Bits {
    private Bits() {
    }

    static char makeChar(byte b1, byte b0) {
        return (char)(b1 << 8 | b0 & 0xFF);
    }

    static char getCharL(byte[] bb, int bi) {
        return Bits.makeChar(bb[bi + 1], bb[bi]);
    }

    static char getCharB(byte[] bb, int bi) {
        return Bits.makeChar(bb[bi], bb[bi + 1]);
    }

    static char getChar(byte[] bb, int bi, boolean bigEndian) {
        return bigEndian ? Bits.getCharB(bb, bi) : Bits.getCharL(bb, bi);
    }

    static byte char1(char x) {
        return (byte)(x >> 8);
    }

    static byte char0(char x) {
        return (byte)x;
    }

    static void putCharL(byte[] bb, int bi, char x) {
        bb[bi] = Bits.char0(x);
        bb[bi + 1] = Bits.char1(x);
    }

    static void putCharB(byte[] bb, int bi, char x) {
        bb[bi] = Bits.char1(x);
        bb[bi + 1] = Bits.char0(x);
    }

    static void putChar(byte[] bb, int bi, char x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putCharB(bb, bi, x);
        } else {
            Bits.putCharL(bb, bi, x);
        }
    }

    static short makeShort(byte b1, byte b0) {
        return (short)(b1 << 8 | b0 & 0xFF);
    }

    static short getShortL(byte[] bb, int bi) {
        return Bits.makeShort(bb[bi + 1], bb[bi]);
    }

    static short getShortB(byte[] bb, int bi) {
        return Bits.makeShort(bb[bi], bb[bi + 1]);
    }

    static short getShort(byte[] bb, int bi, boolean bigEndian) {
        return bigEndian ? Bits.getShortB(bb, bi) : Bits.getShortL(bb, bi);
    }

    static byte short1(short x) {
        return (byte)(x >> 8);
    }

    static byte short0(short x) {
        return (byte)x;
    }

    static void putShortL(byte[] bb, int bi, short x) {
        bb[bi] = Bits.short0(x);
        bb[bi + 1] = Bits.short1(x);
    }

    static void putShortB(byte[] bb, int bi, short x) {
        bb[bi] = Bits.short1(x);
        bb[bi + 1] = Bits.short0(x);
    }

    static void putShort(byte[] bb, int bi, short x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putShortB(bb, bi, x);
        } else {
            Bits.putShortL(bb, bi, x);
        }
    }

    static int makeInt(byte b3, byte b2, byte b1, byte b0) {
        return (b3 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | b0 & 0xFF;
    }

    static int getIntL(byte[] bb, int bi) {
        return Bits.makeInt(bb[bi + 3], bb[bi + 2], bb[bi + 1], bb[bi]);
    }

    static int getIntB(byte[] bb, int bi) {
        return Bits.makeInt(bb[bi], bb[bi + 1], bb[bi + 2], bb[bi + 3]);
    }

    static int getInt(byte[] bb, int bi, boolean bigEndian) {
        return bigEndian ? Bits.getIntB(bb, bi) : Bits.getIntL(bb, bi);
    }

    static byte int3(int x) {
        return (byte)(x >> 24);
    }

    static byte int2(int x) {
        return (byte)(x >> 16);
    }

    static byte int1(int x) {
        return (byte)(x >> 8);
    }

    static byte int0(int x) {
        return (byte)x;
    }

    static void putIntL(byte[] bb, int bi, int x) {
        bb[bi + 3] = Bits.int3(x);
        bb[bi + 2] = Bits.int2(x);
        bb[bi + 1] = Bits.int1(x);
        bb[bi] = Bits.int0(x);
    }

    static void putIntB(byte[] bb, int bi, int x) {
        bb[bi] = Bits.int3(x);
        bb[bi + 1] = Bits.int2(x);
        bb[bi + 2] = Bits.int1(x);
        bb[bi + 3] = Bits.int0(x);
    }

    static void putInt(byte[] bb, int bi, int x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putIntB(bb, bi, x);
        } else {
            Bits.putIntL(bb, bi, x);
        }
    }

    static long makeLong(byte b7, byte b6, byte b5, byte b4, byte b3, byte b2, byte b1, byte b0) {
        return ((long)b7 & 0xFFL) << 56 | ((long)b6 & 0xFFL) << 48 | ((long)b5 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b3 & 0xFFL) << 24 | ((long)b2 & 0xFFL) << 16 | ((long)b1 & 0xFFL) << 8 | (long)b0 & 0xFFL;
    }

    static long getLongL(byte[] bb, int bi) {
        return Bits.makeLong(bb[bi + 7], bb[bi + 6], bb[bi + 5], bb[bi + 4], bb[bi + 3], bb[bi + 2], bb[bi + 1], bb[bi]);
    }

    static long getLongB(byte[] bb, int bi) {
        return Bits.makeLong(bb[bi], bb[bi + 1], bb[bi + 2], bb[bi + 3], bb[bi + 4], bb[bi + 5], bb[bi + 6], bb[bi + 7]);
    }

    static long getLong(byte[] bb, int bi, boolean bigEndian) {
        return bigEndian ? Bits.getLongB(bb, bi) : Bits.getLongL(bb, bi);
    }

    static byte long7(long x) {
        return (byte)(x >> 56);
    }

    static byte long6(long x) {
        return (byte)(x >> 48);
    }

    static byte long5(long x) {
        return (byte)(x >> 40);
    }

    static byte long4(long x) {
        return (byte)(x >> 32);
    }

    static byte long3(long x) {
        return (byte)(x >> 24);
    }

    static byte long2(long x) {
        return (byte)(x >> 16);
    }

    static byte long1(long x) {
        return (byte)(x >> 8);
    }

    static byte long0(long x) {
        return (byte)x;
    }

    static void putLongL(byte[] bb, int bi, long x) {
        bb[bi + 7] = Bits.long7(x);
        bb[bi + 6] = Bits.long6(x);
        bb[bi + 5] = Bits.long5(x);
        bb[bi + 4] = Bits.long4(x);
        bb[bi + 3] = Bits.long3(x);
        bb[bi + 2] = Bits.long2(x);
        bb[bi + 1] = Bits.long1(x);
        bb[bi] = Bits.long0(x);
    }

    static void putLongB(byte[] bb, int bi, long x) {
        bb[bi] = Bits.long7(x);
        bb[bi + 1] = Bits.long6(x);
        bb[bi + 2] = Bits.long5(x);
        bb[bi + 3] = Bits.long4(x);
        bb[bi + 4] = Bits.long3(x);
        bb[bi + 5] = Bits.long2(x);
        bb[bi + 6] = Bits.long1(x);
        bb[bi + 7] = Bits.long0(x);
    }

    static void putLong(byte[] bb, int bi, long x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putLongB(bb, bi, x);
        } else {
            Bits.putLongL(bb, bi, x);
        }
    }

    static float getFloatL(byte[] bb, int bi) {
        return Float.intBitsToFloat(Bits.getIntL(bb, bi));
    }

    static float getFloatB(byte[] bb, int bi) {
        return Float.intBitsToFloat(Bits.getIntB(bb, bi));
    }

    static float getFloat(byte[] bb, int bi, boolean bigEndian) {
        return bigEndian ? Bits.getFloatB(bb, bi) : Bits.getFloatL(bb, bi);
    }

    static void putFloatL(byte[] bb, int bi, float x) {
        Bits.putIntL(bb, bi, Float.floatToRawIntBits(x));
    }

    static void putFloatB(byte[] bb, int bi, float x) {
        Bits.putIntB(bb, bi, Float.floatToRawIntBits(x));
    }

    static void putFloat(byte[] bb, int bi, float x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putFloatB(bb, bi, x);
        } else {
            Bits.putFloatL(bb, bi, x);
        }
    }

    static double getDoubleL(byte[] bb, int bi) {
        return Double.longBitsToDouble(Bits.getLongL(bb, bi));
    }

    static double getDoubleB(byte[] bb, int bi) {
        return Double.longBitsToDouble(Bits.getLongB(bb, bi));
    }

    static double getDouble(byte[] bb, int bi, boolean bigEndian) {
        return bigEndian ? Bits.getDoubleB(bb, bi) : Bits.getDoubleL(bb, bi);
    }

    static void putDoubleL(byte[] bb, int bi, double x) {
        Bits.putLongL(bb, bi, Double.doubleToRawLongBits(x));
    }

    static void putDoubleB(byte[] bb, int bi, double x) {
        Bits.putLongB(bb, bi, Double.doubleToRawLongBits(x));
    }

    static void putDouble(byte[] bb, int bi, double x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putDoubleB(bb, bi, x);
        } else {
            Bits.putDoubleL(bb, bi, x);
        }
    }
}

