/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.memory;

import com.pdd.pop.ext.glassfish.grizzly.Buffer;
import com.pdd.pop.ext.glassfish.grizzly.ThreadCache;
import com.pdd.pop.ext.glassfish.grizzly.memory.AbstractBufferArray;
import com.pdd.pop.ext.glassfish.grizzly.memory.Buffers;

public final class BufferArray
extends AbstractBufferArray<Buffer> {
    private static final ThreadCache.CachedTypeIndex<BufferArray> CACHE_IDX = ThreadCache.obtainIndex(BufferArray.class, Integer.getInteger(BufferArray.class.getName() + "ba-cache-size", 4));

    public static BufferArray create() {
        BufferArray array = ThreadCache.takeFromCache(CACHE_IDX);
        if (array != null) {
            return array;
        }
        return new BufferArray();
    }

    private BufferArray() {
        super(Buffer.class);
    }

    @Override
    public void recycle() {
        super.recycle();
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    @Override
    protected void setPositionLimit(Buffer buffer, int position, int limit) {
        Buffers.setPositionLimit(buffer, position, limit);
    }

    @Override
    protected int getPosition(Buffer buffer) {
        return buffer.position();
    }

    @Override
    protected int getLimit(Buffer buffer) {
        return buffer.limit();
    }
}

