/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.memory;

import com.pdd.pop.ext.glassfish.grizzly.ThreadCache;
import com.pdd.pop.ext.glassfish.grizzly.memory.AbstractBufferArray;
import com.pdd.pop.ext.glassfish.grizzly.memory.Buffers;
import java.nio.ByteBuffer;

public final class ByteBufferArray
extends AbstractBufferArray<ByteBuffer> {
    private static final ThreadCache.CachedTypeIndex<ByteBufferArray> CACHE_IDX = ThreadCache.obtainIndex(ByteBufferArray.class, Integer.getInteger(ByteBufferArray.class.getName() + "bba-cache-size", 4));

    public static ByteBufferArray create() {
        ByteBufferArray array = ThreadCache.takeFromCache(CACHE_IDX);
        if (array != null) {
            return array;
        }
        return new ByteBufferArray();
    }

    private ByteBufferArray() {
        super(ByteBuffer.class);
    }

    @Override
    public void recycle() {
        super.recycle();
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    @Override
    protected void setPositionLimit(ByteBuffer buffer, int position, int limit) {
        Buffers.setPositionLimit(buffer, position, limit);
    }

    @Override
    protected int getPosition(ByteBuffer buffer) {
        return buffer.position();
    }

    @Override
    protected int getLimit(ByteBuffer buffer) {
        return buffer.limit();
    }
}

