/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.memory;

import com.pdd.pop.ext.glassfish.grizzly.Buffer;
import com.pdd.pop.ext.glassfish.grizzly.memory.BufferArray;
import com.pdd.pop.ext.glassfish.grizzly.memory.Buffers;
import com.pdd.pop.ext.glassfish.grizzly.memory.ByteBufferArray;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

public class ByteBufferWrapper
implements Buffer {
    public static volatile boolean DEBUG_MODE = false;
    protected ByteBuffer visible;
    protected boolean allowBufferDispose = false;
    protected Exception disposeStackTrace;

    protected ByteBufferWrapper() {
        this(null);
    }

    public ByteBufferWrapper(ByteBuffer underlyingByteBuffer) {
        this.visible = underlyingByteBuffer;
    }

    @Override
    public final boolean isComposite() {
        return false;
    }

    @Override
    public ByteBufferWrapper prepend(Buffer header) {
        this.checkDispose();
        return this;
    }

    @Override
    public void trim() {
        this.checkDispose();
        this.flip();
    }

    @Override
    public void shrink() {
        this.checkDispose();
    }

    @Override
    public boolean isDirect() {
        this.checkDispose();
        return this.visible.isDirect();
    }

    @Override
    public final boolean allowBufferDispose() {
        return this.allowBufferDispose;
    }

    @Override
    public final void allowBufferDispose(boolean allowBufferDispose) {
        this.allowBufferDispose = allowBufferDispose;
    }

    @Override
    public final boolean tryDispose() {
        if (this.allowBufferDispose) {
            this.dispose();
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        this.prepareDispose();
        this.visible = null;
    }

    protected final void prepareDispose() {
        this.checkDispose();
        if (DEBUG_MODE) {
            DebugLogic.doDebug(this);
        }
    }

    @Override
    public ByteBuffer underlying() {
        this.checkDispose();
        return this.visible;
    }

    @Override
    public final int capacity() {
        return this.visible.capacity();
    }

    @Override
    public final int position() {
        this.checkDispose();
        return this.visible.position();
    }

    @Override
    public final ByteBufferWrapper position(int newPosition) {
        this.checkDispose();
        this.visible.position(newPosition);
        return this;
    }

    @Override
    public final int limit() {
        this.checkDispose();
        return this.visible.limit();
    }

    @Override
    public final ByteBufferWrapper limit(int newLimit) {
        this.checkDispose();
        this.visible.limit(newLimit);
        return this;
    }

    @Override
    public final ByteBufferWrapper mark() {
        this.checkDispose();
        this.visible.mark();
        return this;
    }

    @Override
    public final ByteBufferWrapper reset() {
        this.checkDispose();
        this.visible.reset();
        return this;
    }

    @Override
    public final ByteBufferWrapper clear() {
        this.checkDispose();
        this.visible.clear();
        return this;
    }

    @Override
    public final ByteBufferWrapper flip() {
        this.checkDispose();
        this.visible.flip();
        return this;
    }

    @Override
    public final ByteBufferWrapper rewind() {
        this.checkDispose();
        this.visible.rewind();
        return this;
    }

    @Override
    public final int remaining() {
        this.checkDispose();
        return this.visible.remaining();
    }

    @Override
    public final boolean hasRemaining() {
        this.checkDispose();
        return this.visible.hasRemaining();
    }

    @Override
    public boolean isReadOnly() {
        this.checkDispose();
        return this.visible.isReadOnly();
    }

    @Override
    public Buffer split(int splitPosition) {
        this.checkDispose();
        int cap = this.capacity();
        if (splitPosition < 0 || splitPosition > cap) {
            throw new IllegalArgumentException("Invalid splitPosition value, should be 0 <= splitPosition <= capacity");
        }
        if (splitPosition == cap) {
            return Buffers.EMPTY_BUFFER;
        }
        int oldPosition = this.position();
        int oldLimit = this.limit();
        Buffers.setPositionLimit(this.visible, 0, splitPosition);
        ByteBuffer slice1 = this.visible.slice();
        Buffers.setPositionLimit(this.visible, splitPosition, this.visible.capacity());
        ByteBuffer slice2 = this.visible.slice();
        if (oldPosition < splitPosition) {
            slice1.position(oldPosition);
        } else {
            slice1.position(slice1.capacity());
            slice2.position(oldPosition - splitPosition);
        }
        if (oldLimit < splitPosition) {
            slice1.limit(oldLimit);
            slice2.limit(0);
        } else {
            slice2.limit(oldLimit - splitPosition);
        }
        this.visible = slice1;
        return this.wrapByteBuffer(slice2);
    }

    @Override
    public ByteBufferWrapper slice() {
        return this.slice(this.position(), this.limit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBufferWrapper slice(int position, int limit) {
        this.checkDispose();
        int oldPosition = this.position();
        int oldLimit = this.limit();
        try {
            Buffers.setPositionLimit(this.visible, position, limit);
            ByteBuffer slice = this.visible.slice();
            ByteBufferWrapper byteBufferWrapper = this.wrapByteBuffer(slice);
            return byteBufferWrapper;
        }
        finally {
            Buffers.setPositionLimit(this.visible, oldPosition, oldLimit);
        }
    }

    @Override
    public ByteBufferWrapper duplicate() {
        this.checkDispose();
        ByteBuffer duplicate = this.visible.duplicate();
        return this.wrapByteBuffer(duplicate);
    }

    @Override
    public ByteBufferWrapper asReadOnlyBuffer() {
        this.checkDispose();
        return this.wrapByteBuffer(this.visible.asReadOnlyBuffer());
    }

    @Override
    public byte get() {
        this.checkDispose();
        return this.visible.get();
    }

    @Override
    public byte get(int index) {
        this.checkDispose();
        return this.visible.get(index);
    }

    @Override
    public ByteBufferWrapper put(byte b) {
        this.checkDispose();
        this.visible.put(b);
        return this;
    }

    @Override
    public ByteBufferWrapper put(int index, byte b) {
        this.checkDispose();
        this.visible.put(index, b);
        return this;
    }

    @Override
    public ByteBufferWrapper get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    @Override
    public ByteBufferWrapper get(byte[] dst, int offset, int length) {
        this.checkDispose();
        Buffers.get(this.visible, dst, offset, length);
        return this;
    }

    @Override
    public ByteBufferWrapper put(Buffer src) {
        this.put(src, src.position(), src.remaining());
        src.position(src.limit());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBufferWrapper put(Buffer src, int position, int length) {
        int oldPos = src.position();
        int oldLim = this.limit();
        src.position(position);
        this.limit(this.position() + length);
        try {
            src.get(this.visible);
        }
        finally {
            src.position(oldPos);
            this.limit(oldLim);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer get(ByteBuffer dst) {
        this.checkDispose();
        int length = dst.remaining();
        if (this.visible.remaining() < length) {
            throw new BufferUnderflowException();
        }
        int srcPos = this.visible.position();
        int oldSrcLim = this.visible.limit();
        try {
            this.visible.limit(srcPos + length);
            dst.put(this.visible);
        }
        finally {
            this.visible.limit(oldSrcLim);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer get(ByteBuffer dst, int position, int length) {
        this.checkDispose();
        if (this.visible.remaining() < length) {
            throw new BufferUnderflowException();
        }
        int srcPos = this.visible.position();
        int oldSrcLim = this.visible.limit();
        int oldDstPos = dst.position();
        int oldDstLim = dst.limit();
        Buffers.setPositionLimit(dst, position, position + length);
        try {
            this.visible.limit(srcPos + length);
            dst.put(this.visible);
        }
        finally {
            this.visible.limit(oldSrcLim);
            Buffers.setPositionLimit(dst, oldDstPos, oldDstLim);
        }
        return this;
    }

    @Override
    public Buffer put(ByteBuffer src) {
        this.checkDispose();
        this.visible.put(src);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer put(ByteBuffer src, int position, int length) {
        this.checkDispose();
        int oldPos = src.position();
        int oldLim = src.limit();
        try {
            Buffers.setPositionLimit(src, position, position + length);
            this.visible.put(src);
        }
        finally {
            Buffers.setPositionLimit(src, oldPos, oldLim);
        }
        return this;
    }

    @Override
    public ByteBufferWrapper put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    @Override
    public ByteBufferWrapper put(byte[] src, int offset, int length) {
        this.checkDispose();
        Buffers.put(src, offset, length, this.visible);
        return this;
    }

    @Override
    public Buffer put8BitString(String s) {
        this.checkDispose();
        int len = s.length();
        if (this.remaining() < len) {
            throw new BufferOverflowException();
        }
        for (int i = 0; i < len; ++i) {
            this.visible.put((byte)s.charAt(i));
        }
        return this;
    }

    @Override
    public ByteBufferWrapper compact() {
        this.checkDispose();
        this.visible.compact();
        return this;
    }

    @Override
    public ByteOrder order() {
        this.checkDispose();
        return this.visible.order();
    }

    @Override
    public ByteBufferWrapper order(ByteOrder bo) {
        this.checkDispose();
        this.visible.order(bo);
        return this;
    }

    @Override
    public char getChar() {
        this.checkDispose();
        return this.visible.getChar();
    }

    @Override
    public char getChar(int index) {
        this.checkDispose();
        return this.visible.getChar(index);
    }

    @Override
    public ByteBufferWrapper putChar(char value) {
        this.checkDispose();
        this.visible.putChar(value);
        return this;
    }

    @Override
    public ByteBufferWrapper putChar(int index, char value) {
        this.checkDispose();
        this.visible.putChar(index, value);
        return this;
    }

    @Override
    public short getShort() {
        this.checkDispose();
        return this.visible.getShort();
    }

    @Override
    public short getShort(int index) {
        this.checkDispose();
        return this.visible.getShort(index);
    }

    @Override
    public ByteBufferWrapper putShort(short value) {
        this.checkDispose();
        this.visible.putShort(value);
        return this;
    }

    @Override
    public ByteBufferWrapper putShort(int index, short value) {
        this.checkDispose();
        this.visible.putShort(index, value);
        return this;
    }

    @Override
    public int getInt() {
        this.checkDispose();
        return this.visible.getInt();
    }

    @Override
    public int getInt(int index) {
        this.checkDispose();
        return this.visible.getInt(index);
    }

    @Override
    public ByteBufferWrapper putInt(int value) {
        this.checkDispose();
        this.visible.putInt(value);
        return this;
    }

    @Override
    public ByteBufferWrapper putInt(int index, int value) {
        this.checkDispose();
        this.visible.putInt(index, value);
        return this;
    }

    @Override
    public long getLong() {
        this.checkDispose();
        return this.visible.getLong();
    }

    @Override
    public long getLong(int index) {
        this.checkDispose();
        return this.visible.getLong(index);
    }

    @Override
    public ByteBufferWrapper putLong(long value) {
        this.checkDispose();
        this.visible.putLong(value);
        return this;
    }

    @Override
    public ByteBufferWrapper putLong(int index, long value) {
        this.checkDispose();
        this.visible.putLong(index, value);
        return this;
    }

    @Override
    public float getFloat() {
        this.checkDispose();
        return this.visible.getFloat();
    }

    @Override
    public float getFloat(int index) {
        this.checkDispose();
        return this.visible.getFloat(index);
    }

    @Override
    public ByteBufferWrapper putFloat(float value) {
        this.checkDispose();
        this.visible.putFloat(value);
        return this;
    }

    @Override
    public ByteBufferWrapper putFloat(int index, float value) {
        this.checkDispose();
        this.visible.putFloat(index, value);
        return this;
    }

    @Override
    public double getDouble() {
        this.checkDispose();
        return this.visible.getDouble();
    }

    @Override
    public double getDouble(int index) {
        this.checkDispose();
        return this.visible.getDouble(index);
    }

    @Override
    public ByteBufferWrapper putDouble(double value) {
        this.checkDispose();
        this.visible.putDouble(value);
        return this;
    }

    @Override
    public ByteBufferWrapper putDouble(int index, double value) {
        this.checkDispose();
        this.visible.putDouble(index, value);
        return this;
    }

    public int hashCode() {
        return this.visible.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Buffer) {
            Buffer that = (Buffer)obj;
            if (this.remaining() != that.remaining()) {
                return false;
            }
            int p = this.position();
            int i = this.limit() - 1;
            int j = that.limit() - 1;
            while (i >= p) {
                byte v2;
                byte v1 = this.get(i);
                if (v1 != (v2 = that.get(j))) {
                    return false;
                }
                --i;
                --j;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(Buffer o) {
        int n = this.position() + Math.min(this.remaining(), o.remaining());
        int i = this.position();
        int j = o.position();
        while (i < n) {
            byte v2;
            byte v1 = this.get(i);
            if (v1 != (v2 = o.get(j))) {
                if (v1 < v2) {
                    return -1;
                }
                return 1;
            }
            ++i;
            ++j;
        }
        return this.remaining() - o.remaining();
    }

    protected void checkDispose() {
        if (this.visible == null) {
            throw new IllegalStateException("BufferWrapper has already been disposed", this.disposeStackTrace);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ByteBufferWrapper (" + System.identityHashCode(this) + ") [");
        sb.append("visible=[").append(this.visible).append(']');
        sb.append(']');
        return sb.toString();
    }

    @Override
    public String toStringContent() {
        return this.toStringContent(Charset.defaultCharset(), this.position(), this.limit());
    }

    @Override
    public String toStringContent(Charset charset) {
        return this.toStringContent(charset, this.position(), this.limit());
    }

    @Override
    public String toStringContent(Charset charset, int position, int limit) {
        this.checkDispose();
        return Buffers.toStringContent(this.visible, charset, position, limit);
    }

    @Override
    public void dumpHex(Appendable appendable) {
        Buffers.dumpBuffer(appendable, this);
    }

    @Override
    public final ByteBuffer toByteBuffer() {
        this.checkDispose();
        return this.visible;
    }

    @Override
    public final ByteBuffer toByteBuffer(int position, int limit) {
        this.checkDispose();
        int currentPosition = this.visible.position();
        int currentLimit = this.visible.limit();
        if (position == currentPosition && limit == currentLimit) {
            return this.toByteBuffer();
        }
        Buffers.setPositionLimit(this.visible, position, limit);
        ByteBuffer resultBuffer = this.visible.slice();
        Buffers.setPositionLimit(this.visible, currentPosition, currentLimit);
        return resultBuffer;
    }

    @Override
    public final ByteBufferArray toByteBufferArray() {
        this.checkDispose();
        ByteBufferArray array = ByteBufferArray.create();
        array.add(this.visible);
        return array;
    }

    @Override
    public final ByteBufferArray toByteBufferArray(int position, int limit) {
        return this.toByteBufferArray(ByteBufferArray.create(), position, limit);
    }

    @Override
    public final ByteBufferArray toByteBufferArray(ByteBufferArray array) {
        this.checkDispose();
        array.add(this.visible);
        return array;
    }

    @Override
    public final ByteBufferArray toByteBufferArray(ByteBufferArray array, int position, int limit) {
        this.checkDispose();
        int oldPos = this.visible.position();
        int oldLim = this.visible.limit();
        Buffers.setPositionLimit(this.visible, position, limit);
        array.add(this.visible, oldPos, oldLim);
        return array;
    }

    @Override
    public final BufferArray toBufferArray() {
        this.checkDispose();
        BufferArray array = BufferArray.create();
        array.add(this);
        return array;
    }

    @Override
    public final BufferArray toBufferArray(int position, int limit) {
        return this.toBufferArray(BufferArray.create(), position, limit);
    }

    @Override
    public final BufferArray toBufferArray(BufferArray array) {
        this.checkDispose();
        array.add(this);
        return array;
    }

    @Override
    public final BufferArray toBufferArray(BufferArray array, int position, int limit) {
        this.checkDispose();
        int oldPos = this.visible.position();
        int oldLim = this.visible.limit();
        Buffers.setPositionLimit(this.visible, position, limit);
        array.add(this, oldPos, oldLim);
        return array;
    }

    @Override
    public boolean release() {
        return this.tryDispose();
    }

    @Override
    public boolean isExternal() {
        return false;
    }

    @Override
    public boolean hasArray() {
        return this.visible.hasArray();
    }

    @Override
    public byte[] array() {
        return this.visible.array();
    }

    @Override
    public int arrayOffset() {
        return this.visible.arrayOffset();
    }

    protected ByteBufferWrapper wrapByteBuffer(ByteBuffer byteBuffer) {
        return new ByteBufferWrapper(byteBuffer);
    }

    private static class DebugLogic {
        private DebugLogic() {
        }

        static void doDebug(ByteBufferWrapper wrapper) {
            wrapper.visible.clear();
            while (wrapper.visible.hasRemaining()) {
                wrapper.visible.put((byte)-1);
            }
            wrapper.visible.flip();
            wrapper.disposeStackTrace = new Exception("ByteBufferWrapper was disposed from: ");
        }
    }
}

