/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.nio.transport;

import com.pdd.pop.ext.glassfish.grizzly.Buffer;
import com.pdd.pop.ext.glassfish.grizzly.CompletionHandler;
import com.pdd.pop.ext.glassfish.grizzly.Connection;
import com.pdd.pop.ext.glassfish.grizzly.GrizzlyFuture;
import com.pdd.pop.ext.glassfish.grizzly.WriteResult;
import com.pdd.pop.ext.glassfish.grizzly.impl.FutureImpl;
import com.pdd.pop.ext.glassfish.grizzly.impl.SafeFutureImpl;
import com.pdd.pop.ext.glassfish.grizzly.memory.Buffers;
import com.pdd.pop.ext.glassfish.grizzly.streams.AbstractStreamWriter;
import com.pdd.pop.ext.glassfish.grizzly.streams.BufferedOutput;
import java.io.IOException;
import java.net.SocketAddress;

public final class DefaultStreamWriter
extends AbstractStreamWriter {
    public DefaultStreamWriter(Connection connection) {
        super(connection, new Output(connection));
    }

    @Override
    public GrizzlyFuture<Integer> flush(CompletionHandler<Integer> completionHandler) throws IOException {
        return super.flush(new ResetCounterCompletionHandler((Output)this.output, completionHandler));
    }

    private static final class ResetCounterCompletionHandler
    implements CompletionHandler<Integer> {
        private final Output output;
        private final CompletionHandler<Integer> parentCompletionHandler;

        public ResetCounterCompletionHandler(Output output, CompletionHandler<Integer> parentCompletionHandler) {
            this.output = output;
            this.parentCompletionHandler = parentCompletionHandler;
        }

        @Override
        public void cancelled() {
            if (this.parentCompletionHandler != null) {
                this.parentCompletionHandler.cancelled();
            }
        }

        @Override
        public void failed(Throwable throwable) {
            if (this.parentCompletionHandler != null) {
                this.parentCompletionHandler.failed(throwable);
            }
        }

        @Override
        public void completed(Integer result) {
            this.output.sentBytesCounter = 0;
            if (this.parentCompletionHandler != null) {
                this.parentCompletionHandler.completed(result);
            }
        }

        @Override
        public void updated(Integer result) {
            if (this.parentCompletionHandler != null) {
                this.parentCompletionHandler.updated(result);
            }
        }
    }

    private static final class CompletionHandlerAdapter
    implements CompletionHandler<WriteResult<Buffer, SocketAddress>> {
        private final Output output;
        private final FutureImpl<Integer> future;
        private final CompletionHandler<Integer> completionHandler;

        public CompletionHandlerAdapter(Output output, FutureImpl<Integer> future, CompletionHandler<Integer> completionHandler) {
            this.output = output;
            this.future = future;
            this.completionHandler = completionHandler;
        }

        @Override
        public void cancelled() {
            if (this.completionHandler != null) {
                this.completionHandler.cancelled();
            }
            if (this.future != null) {
                this.future.cancel(false);
            }
        }

        @Override
        public void failed(Throwable throwable) {
            if (this.completionHandler != null) {
                this.completionHandler.failed(throwable);
            }
            if (this.future != null) {
                this.future.failure(throwable);
            }
        }

        @Override
        public void completed(WriteResult result) {
            this.output.sentBytesCounter = (int)((long)this.output.sentBytesCounter + result.getWrittenSize());
            int totalSentBytes = this.output.sentBytesCounter;
            if (this.completionHandler != null) {
                this.completionHandler.completed(totalSentBytes);
            }
            if (this.future != null) {
                this.future.result(totalSentBytes);
            }
        }

        @Override
        public void updated(WriteResult result) {
            if (this.completionHandler != null) {
                this.completionHandler.updated(this.output.sentBytesCounter + (int)result.getWrittenSize());
            }
        }
    }

    public static final class Output
    extends BufferedOutput {
        private final Connection connection;
        private int sentBytesCounter;

        public Output(Connection connection) {
            super(connection.getWriteBufferSize());
            this.connection = connection;
        }

        @Override
        protected GrizzlyFuture<Integer> flush0(Buffer buffer, CompletionHandler<Integer> completionHandler) throws IOException {
            SafeFutureImpl<Integer> future = SafeFutureImpl.create();
            if (buffer == null) {
                buffer = Buffers.EMPTY_BUFFER;
            }
            this.connection.write(buffer, new CompletionHandlerAdapter(this, future, completionHandler));
            return future;
        }

        @Override
        protected Buffer newBuffer(int size) {
            return this.connection.getMemoryManager().allocate(size);
        }

        @Override
        protected Buffer reallocateBuffer(Buffer oldBuffer, int size) {
            return this.connection.getMemoryManager().reallocate(oldBuffer, size);
        }

        @Override
        protected void onClosed() throws IOException {
            this.connection.closeSilently();
        }
    }
}

