/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.nio.transport;

import com.pdd.pop.ext.glassfish.grizzly.Buffer;
import com.pdd.pop.ext.glassfish.grizzly.CompletionHandler;
import com.pdd.pop.ext.glassfish.grizzly.Connection;
import com.pdd.pop.ext.glassfish.grizzly.IOEvent;
import com.pdd.pop.ext.glassfish.grizzly.Interceptor;
import com.pdd.pop.ext.glassfish.grizzly.ReadResult;
import com.pdd.pop.ext.glassfish.grizzly.asyncqueue.AsyncReadQueueRecord;
import com.pdd.pop.ext.glassfish.grizzly.nio.AbstractNIOAsyncQueueReader;
import com.pdd.pop.ext.glassfish.grizzly.nio.NIOConnection;
import com.pdd.pop.ext.glassfish.grizzly.nio.NIOTransport;
import com.pdd.pop.ext.glassfish.grizzly.nio.transport.TCPNIOConnection;
import com.pdd.pop.ext.glassfish.grizzly.nio.transport.TCPNIOTransport;
import java.io.IOException;
import java.net.SocketAddress;

public final class TCPNIOAsyncQueueReader
extends AbstractNIOAsyncQueueReader {
    public TCPNIOAsyncQueueReader(NIOTransport transport) {
        super(transport);
    }

    @Override
    protected int read0(Connection connection, Buffer buffer, ReadResult<Buffer, SocketAddress> currentResult) throws IOException {
        int oldPosition = buffer != null ? buffer.position() : 0;
        if ((buffer = ((TCPNIOTransport)this.transport).read(connection, buffer)) != null) {
            int readBytes = buffer.position() - oldPosition;
            currentResult.setMessage(buffer);
            currentResult.setReadSize(currentResult.getReadSize() + readBytes);
            currentResult.setSrcAddressHolder(((TCPNIOConnection)connection).peerSocketAddressHolder);
            return readBytes;
        }
        return 0;
    }

    protected void addRecord(Connection connection, Buffer buffer, CompletionHandler completionHandler, Interceptor<ReadResult> interceptor) {
        AsyncReadQueueRecord record = AsyncReadQueueRecord.create(connection, buffer, completionHandler, interceptor);
        ((TCPNIOConnection)connection).getAsyncReadQueue().offer(record);
    }

    @Override
    protected final void onReadyToRead(Connection connection) throws IOException {
        NIOConnection nioConnection = (NIOConnection)connection;
        nioConnection.enableIOEvent(IOEvent.READ);
    }
}

