/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.nio.transport;

import com.pdd.pop.ext.glassfish.grizzly.CloseReason;
import com.pdd.pop.ext.glassfish.grizzly.Closeable;
import com.pdd.pop.ext.glassfish.grizzly.CompletionHandler;
import com.pdd.pop.ext.glassfish.grizzly.Grizzly;
import com.pdd.pop.ext.glassfish.grizzly.Processor;
import com.pdd.pop.ext.glassfish.grizzly.ProcessorSelector;
import com.pdd.pop.ext.glassfish.grizzly.impl.FutureImpl;
import com.pdd.pop.ext.glassfish.grizzly.nio.transport.UDPNIOConnection;
import com.pdd.pop.ext.glassfish.grizzly.nio.transport.UDPNIOTransport;
import com.pdd.pop.ext.glassfish.grizzly.utils.Futures;
import java.io.IOException;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UDPNIOServerConnection
extends UDPNIOConnection {
    private static final Logger LOGGER = Grizzly.logger(UDPNIOServerConnection.class);

    public UDPNIOServerConnection(UDPNIOTransport transport, DatagramChannel channel) {
        super(transport, channel);
    }

    @Override
    public Processor getProcessor() {
        if (this.processor == null) {
            return this.transport.getProcessor();
        }
        return this.processor;
    }

    @Override
    public ProcessorSelector getProcessorSelector() {
        if (this.processorSelector == null) {
            return this.transport.getProcessorSelector();
        }
        return this.processorSelector;
    }

    public void register() throws IOException {
        FutureImpl future = Futures.createSafeFuture();
        this.transport.getNIOChannelDistributor().registerServiceChannelAsync(this.channel, 1, this, Futures.toCompletionHandler(future, ((UDPNIOTransport)this.transport).registerChannelCompletionHandler));
        try {
            future.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new IOException("Error registering server channel key", e);
        }
        this.notifyReady();
    }

    @Override
    protected void closeGracefully0(CompletionHandler<Closeable> completionHandler, CloseReason closeReason) {
        this.terminate0(completionHandler, closeReason);
    }

    @Override
    protected void terminate0(CompletionHandler<Closeable> completionHandler, CloseReason closeReason) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("UDPNIOServerConnection might be only closed by calling unbind().");
        }
        if (completionHandler != null) {
            completionHandler.completed(this);
        }
    }

    public void unbind(CompletionHandler<Closeable> completionHandler) {
        super.terminate0(completionHandler, CloseReason.LOCALLY_CLOSED_REASON);
    }

    @Override
    protected void preClose() {
        this.transport.unbind(this);
        super.preClose();
    }
}

