/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.ssl;

import com.pdd.pop.ext.glassfish.grizzly.Buffer;
import com.pdd.pop.ext.glassfish.grizzly.Codec;
import com.pdd.pop.ext.glassfish.grizzly.Connection;
import com.pdd.pop.ext.glassfish.grizzly.Transformer;
import com.pdd.pop.ext.glassfish.grizzly.ssl.SSLContextConfigurator;
import com.pdd.pop.ext.glassfish.grizzly.ssl.SSLDecoderTransformer;
import com.pdd.pop.ext.glassfish.grizzly.ssl.SSLEncoderTransformer;
import com.pdd.pop.ext.glassfish.grizzly.ssl.SSLEngineConfigurator;
import java.io.IOException;
import java.util.concurrent.Future;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class SSLCodec
implements Codec<Buffer, Buffer> {
    private final SSLEngineConfigurator serverSSLEngineConfig;
    private final SSLEngineConfigurator clientSSLEngineConfig;
    private final Transformer<Buffer, Buffer> decoder = new SSLDecoderTransformer();
    private final Transformer<Buffer, Buffer> encoder = new SSLEncoderTransformer();

    public SSLCodec(SSLContextConfigurator config) {
        this(config.createSSLContext());
    }

    public SSLCodec(SSLContext sslContext) {
        this.serverSSLEngineConfig = new SSLEngineConfigurator(sslContext, false, false, false);
        this.clientSSLEngineConfig = new SSLEngineConfigurator(sslContext, true, false, false);
    }

    @Override
    public Transformer<Buffer, Buffer> getDecoder() {
        return this.decoder;
    }

    @Override
    public Transformer<Buffer, Buffer> getEncoder() {
        return this.encoder;
    }

    public SSLEngineConfigurator getClientSSLEngineConfig() {
        return this.clientSSLEngineConfig;
    }

    public SSLEngineConfigurator getServerSSLEngineConfig() {
        return this.serverSSLEngineConfig;
    }

    public Future<SSLEngine> handshake(Connection connection) throws IOException {
        return this.handshake(connection, this.clientSSLEngineConfig);
    }

    public Future<SSLEngine> handshake(Connection connection, SSLEngineConfigurator configurator) throws IOException {
        return null;
    }
}

