/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.ssl;

import com.pdd.pop.ext.glassfish.grizzly.Grizzly;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class SSLContextConfigurator {
    public static final String TRUST_STORE_PROVIDER = "javax.net.ssl.trustStoreProvider";
    public static final String KEY_STORE_PROVIDER = "javax.net.ssl.keyStoreProvider";
    public static final String TRUST_STORE_FILE = "javax.net.ssl.trustStore";
    public static final String KEY_STORE_FILE = "javax.net.ssl.keyStore";
    public static final String TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    public static final String KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String TRUST_STORE_TYPE = "javax.net.ssl.trustStoreType";
    public static final String KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    public static final String KEY_FACTORY_MANAGER_ALGORITHM = "ssl.KeyManagerFactory.algorithm";
    public static final String TRUST_FACTORY_MANAGER_ALGORITHM = "ssl.TrustManagerFactory.algorithm";
    private static final Logger LOGGER = Grizzly.logger(SSLContextConfigurator.class);
    public static final SSLContextConfigurator DEFAULT_CONFIG = new SSLContextConfigurator();
    private String trustStoreProvider;
    private String keyStoreProvider;
    private String trustStoreType;
    private String keyStoreType;
    private char[] trustStorePass;
    private char[] keyStorePass;
    private char[] keyPass;
    private String trustStoreFile;
    private String keyStoreFile;
    private byte[] trustStoreBytes;
    private byte[] keyStoreBytes;
    private String trustManagerFactoryAlgorithm;
    private String keyManagerFactoryAlgorithm;
    private String securityProtocol = "TLS";

    public SSLContextConfigurator() {
        this(true);
    }

    public SSLContextConfigurator(boolean readSystemProperties) {
        if (readSystemProperties) {
            this.retrieve(System.getProperties());
        }
    }

    public void setTrustStoreProvider(String trustStoreProvider) {
        this.trustStoreProvider = trustStoreProvider;
    }

    public void setKeyStoreProvider(String keyStoreProvider) {
        this.keyStoreProvider = keyStoreProvider;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public void setTrustStorePass(String trustStorePass) {
        this.trustStorePass = trustStorePass.toCharArray();
    }

    public void setKeyStorePass(String keyStorePass) {
        this.keyStorePass = keyStorePass.toCharArray();
    }

    public void setKeyStorePass(char[] keyStorePass) {
        this.keyStorePass = keyStorePass;
    }

    public void setKeyPass(String keyPass) {
        this.keyPass = keyPass.toCharArray();
    }

    public void setKeyPass(char[] keyPass) {
        this.keyPass = keyPass;
    }

    public void setTrustStoreFile(String trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
        this.trustStoreBytes = null;
    }

    public void setTrustStoreBytes(byte[] trustStoreBytes) {
        this.trustStoreBytes = trustStoreBytes;
        this.trustStoreFile = null;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
        this.keyStoreBytes = null;
    }

    public void setKeyStoreBytes(byte[] keyStoreBytes) {
        this.keyStoreBytes = keyStoreBytes;
        this.keyStoreFile = null;
    }

    public void setTrustManagerFactoryAlgorithm(String trustManagerFactoryAlgorithm) {
        this.trustManagerFactoryAlgorithm = trustManagerFactoryAlgorithm;
    }

    public void setKeyManagerFactoryAlgorithm(String keyManagerFactoryAlgorithm) {
        this.keyManagerFactoryAlgorithm = keyManagerFactoryAlgorithm;
    }

    public void setSecurityProtocol(String securityProtocol) {
        this.securityProtocol = securityProtocol;
    }

    public boolean validateConfiguration() {
        return this.validateConfiguration(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateConfiguration(boolean needsKeyStore) {
        boolean valid = true;
        if (this.keyStoreBytes != null || this.keyStoreFile != null) {
            try {
                KeyStore keyStore = this.keyStoreProvider != null ? KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : KeyStore.getDefaultType(), this.keyStoreProvider) : KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : KeyStore.getDefaultType());
                InputStream keyStoreInputStream = null;
                try {
                    if (this.keyStoreBytes != null) {
                        keyStoreInputStream = new ByteArrayInputStream(this.keyStoreBytes);
                    } else if (!this.keyStoreFile.equals("NONE")) {
                        keyStoreInputStream = new FileInputStream(this.keyStoreFile);
                    }
                    keyStore.load(keyStoreInputStream, this.keyStorePass);
                }
                finally {
                    try {
                        if (keyStoreInputStream != null) {
                            keyStoreInputStream.close();
                        }
                    }
                    catch (IOException ignored) {}
                }
                String kmfAlgorithm = this.keyManagerFactoryAlgorithm;
                if (kmfAlgorithm == null) {
                    kmfAlgorithm = System.getProperty(KEY_FACTORY_MANAGER_ALGORITHM, KeyManagerFactory.getDefaultAlgorithm());
                }
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(kmfAlgorithm);
                keyManagerFactory.init(keyStore, this.keyPass != null ? this.keyPass : this.keyStorePass);
            }
            catch (KeyStoreException e) {
                LOGGER.log(Level.FINE, "Error initializing key store", e);
                valid = false;
            }
            catch (CertificateException e) {
                LOGGER.log(Level.FINE, "Key store certificate exception.", e);
                valid = false;
            }
            catch (UnrecoverableKeyException e) {
                LOGGER.log(Level.FINE, "Key store unrecoverable exception.", e);
                valid = false;
            }
            catch (FileNotFoundException e) {
                LOGGER.log(Level.FINE, "Can't find key store file: " + this.keyStoreFile, e);
                valid = false;
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Error loading key store from file: " + this.keyStoreFile, e);
                valid = false;
            }
            catch (NoSuchAlgorithmException e) {
                LOGGER.log(Level.FINE, "Error initializing key manager factory (no such algorithm)", e);
                valid = false;
            }
            catch (NoSuchProviderException e) {
                LOGGER.log(Level.FINE, "Error initializing key store (no such provider)", e);
                valid = false;
            }
        } else {
            valid &= !needsKeyStore;
        }
        if (this.trustStoreBytes != null || this.trustStoreFile != null) {
            try {
                KeyStore trustStore = this.trustStoreProvider != null ? KeyStore.getInstance(this.trustStoreType != null ? this.trustStoreType : KeyStore.getDefaultType(), this.trustStoreProvider) : KeyStore.getInstance(this.trustStoreType != null ? this.trustStoreType : KeyStore.getDefaultType());
                InputStream trustStoreInputStream = null;
                try {
                    if (this.trustStoreBytes != null) {
                        trustStoreInputStream = new ByteArrayInputStream(this.trustStoreBytes);
                    } else if (!this.trustStoreFile.equals("NONE")) {
                        trustStoreInputStream = new FileInputStream(this.trustStoreFile);
                    }
                    trustStore.load(trustStoreInputStream, this.trustStorePass);
                }
                finally {
                    try {
                        if (trustStoreInputStream != null) {
                            trustStoreInputStream.close();
                        }
                    }
                    catch (IOException ignored) {}
                }
                String tmfAlgorithm = this.trustManagerFactoryAlgorithm;
                if (tmfAlgorithm == null) {
                    tmfAlgorithm = System.getProperty(TRUST_FACTORY_MANAGER_ALGORITHM, TrustManagerFactory.getDefaultAlgorithm());
                }
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(tmfAlgorithm);
                trustManagerFactory.init(trustStore);
            }
            catch (KeyStoreException e) {
                LOGGER.log(Level.FINE, "Error initializing trust store", e);
                valid = false;
            }
            catch (CertificateException e) {
                LOGGER.log(Level.FINE, "Trust store certificate exception.", e);
                valid = false;
            }
            catch (FileNotFoundException e) {
                LOGGER.log(Level.FINE, "Can't find trust store file: " + this.trustStoreFile, e);
                valid = false;
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Error loading trust store from file: " + this.trustStoreFile, e);
                valid = false;
            }
            catch (NoSuchAlgorithmException e) {
                LOGGER.log(Level.FINE, "Error initializing trust manager factory (no such algorithm)", e);
                valid = false;
            }
            catch (NoSuchProviderException e) {
                LOGGER.log(Level.FINE, "Error initializing trust store (no such provider)", e);
                valid = false;
            }
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContext createSSLContext() {
        SSLContext sslContext = null;
        try {
            TrustManagerFactory trustManagerFactory = null;
            KeyManagerFactory keyManagerFactory = null;
            if (this.keyStoreBytes != null || this.keyStoreFile != null) {
                try {
                    KeyStore keyStore = this.keyStoreProvider != null ? KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : KeyStore.getDefaultType(), this.keyStoreProvider) : KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : KeyStore.getDefaultType());
                    InputStream keyStoreInputStream = null;
                    try {
                        if (this.keyStoreBytes != null) {
                            keyStoreInputStream = new ByteArrayInputStream(this.keyStoreBytes);
                        } else if (!this.keyStoreFile.equals("NONE")) {
                            keyStoreInputStream = new FileInputStream(this.keyStoreFile);
                        }
                        keyStore.load(keyStoreInputStream, this.keyStorePass);
                    }
                    finally {
                        try {
                            if (keyStoreInputStream != null) {
                                keyStoreInputStream.close();
                            }
                        }
                        catch (IOException ignored) {}
                    }
                    String kmfAlgorithm = this.keyManagerFactoryAlgorithm;
                    if (kmfAlgorithm == null) {
                        kmfAlgorithm = System.getProperty(KEY_FACTORY_MANAGER_ALGORITHM, KeyManagerFactory.getDefaultAlgorithm());
                    }
                    keyManagerFactory = KeyManagerFactory.getInstance(kmfAlgorithm);
                    keyManagerFactory.init(keyStore, this.keyPass != null ? this.keyPass : this.keyStorePass);
                }
                catch (KeyStoreException e) {
                    LOGGER.log(Level.FINE, "Error initializing key store", e);
                }
                catch (CertificateException e) {
                    LOGGER.log(Level.FINE, "Key store certificate exception.", e);
                }
                catch (UnrecoverableKeyException e) {
                    LOGGER.log(Level.FINE, "Key store unrecoverable exception.", e);
                }
                catch (FileNotFoundException e) {
                    LOGGER.log(Level.FINE, "Can't find key store file: " + this.keyStoreFile, e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Error loading key store from file: " + this.keyStoreFile, e);
                }
                catch (NoSuchAlgorithmException e) {
                    LOGGER.log(Level.FINE, "Error initializing key manager factory (no such algorithm)", e);
                }
                catch (NoSuchProviderException e) {
                    LOGGER.log(Level.FINE, "Error initializing key store (no such provider)", e);
                }
            }
            if (this.trustStoreBytes != null || this.trustStoreFile != null) {
                try {
                    KeyStore trustStore = this.trustStoreProvider != null ? KeyStore.getInstance(this.trustStoreType != null ? this.trustStoreType : KeyStore.getDefaultType(), this.trustStoreProvider) : KeyStore.getInstance(this.trustStoreType != null ? this.trustStoreType : KeyStore.getDefaultType());
                    InputStream trustStoreInputStream = null;
                    try {
                        if (this.trustStoreBytes != null) {
                            trustStoreInputStream = new ByteArrayInputStream(this.trustStoreBytes);
                        } else if (!this.trustStoreFile.equals("NONE")) {
                            trustStoreInputStream = new FileInputStream(this.trustStoreFile);
                        }
                        trustStore.load(trustStoreInputStream, this.trustStorePass);
                    }
                    finally {
                        try {
                            if (trustStoreInputStream != null) {
                                trustStoreInputStream.close();
                            }
                        }
                        catch (IOException ignored) {}
                    }
                    String tmfAlgorithm = this.trustManagerFactoryAlgorithm;
                    if (tmfAlgorithm == null) {
                        tmfAlgorithm = System.getProperty(TRUST_FACTORY_MANAGER_ALGORITHM, TrustManagerFactory.getDefaultAlgorithm());
                    }
                    trustManagerFactory = TrustManagerFactory.getInstance(tmfAlgorithm);
                    trustManagerFactory.init(trustStore);
                }
                catch (KeyStoreException e) {
                    LOGGER.log(Level.FINE, "Error initializing trust store", e);
                }
                catch (CertificateException e) {
                    LOGGER.log(Level.FINE, "Trust store certificate exception.", e);
                }
                catch (FileNotFoundException e) {
                    LOGGER.log(Level.FINE, "Can't find trust store file: " + this.trustStoreFile, e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Error loading trust store from file: " + this.trustStoreFile, e);
                }
                catch (NoSuchAlgorithmException e) {
                    LOGGER.log(Level.FINE, "Error initializing trust manager factory (no such algorithm)", e);
                }
                catch (NoSuchProviderException e) {
                    LOGGER.log(Level.FINE, "Error initializing trust store (no such provider)", e);
                }
            }
            String secProtocol = "TLS";
            if (this.securityProtocol != null) {
                secProtocol = this.securityProtocol;
            }
            sslContext = SSLContext.getInstance(secProtocol);
            sslContext.init(keyManagerFactory != null ? keyManagerFactory.getKeyManagers() : null, trustManagerFactory != null ? trustManagerFactory.getTrustManagers() : null, null);
        }
        catch (KeyManagementException e) {
            LOGGER.log(Level.FINE, "Key management error.", e);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.log(Level.FINE, "Error initializing algorithm.", e);
        }
        return sslContext;
    }

    public void retrieve(Properties props) {
        this.trustStoreProvider = props.getProperty(TRUST_STORE_PROVIDER);
        this.keyStoreProvider = props.getProperty(KEY_STORE_PROVIDER);
        this.trustStoreType = props.getProperty(TRUST_STORE_TYPE);
        this.keyStoreType = props.getProperty(KEY_STORE_TYPE);
        this.trustStorePass = (char[])(props.getProperty(TRUST_STORE_PASSWORD) != null ? props.getProperty(TRUST_STORE_PASSWORD).toCharArray() : null);
        this.keyStorePass = (char[])(props.getProperty(KEY_STORE_PASSWORD) != null ? props.getProperty(KEY_STORE_PASSWORD).toCharArray() : null);
        this.trustStoreFile = props.getProperty(TRUST_STORE_FILE);
        this.keyStoreFile = props.getProperty(KEY_STORE_FILE);
        this.trustStoreBytes = null;
        this.keyStoreBytes = null;
        this.securityProtocol = "TLS";
    }
}

