/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.ssl;

import com.pdd.pop.ext.glassfish.grizzly.Buffer;
import com.pdd.pop.ext.glassfish.grizzly.CloseType;
import com.pdd.pop.ext.glassfish.grizzly.Closeable;
import com.pdd.pop.ext.glassfish.grizzly.CompletionHandler;
import com.pdd.pop.ext.glassfish.grizzly.Connection;
import com.pdd.pop.ext.glassfish.grizzly.FileTransfer;
import com.pdd.pop.ext.glassfish.grizzly.GenericCloseListener;
import com.pdd.pop.ext.glassfish.grizzly.Grizzly;
import com.pdd.pop.ext.glassfish.grizzly.PendingWriteQueueLimitExceededException;
import com.pdd.pop.ext.glassfish.grizzly.attributes.Attribute;
import com.pdd.pop.ext.glassfish.grizzly.filterchain.FilterChainContext;
import com.pdd.pop.ext.glassfish.grizzly.filterchain.NextAction;
import com.pdd.pop.ext.glassfish.grizzly.ssl.SSLBaseFilter;
import com.pdd.pop.ext.glassfish.grizzly.ssl.SSLConnectionContext;
import com.pdd.pop.ext.glassfish.grizzly.ssl.SSLContextConfigurator;
import com.pdd.pop.ext.glassfish.grizzly.ssl.SSLEngineConfigurator;
import com.pdd.pop.ext.glassfish.grizzly.ssl.SSLUtils;
import com.pdd.pop.ext.glassfish.grizzly.utils.Exceptions;
import com.pdd.pop.ext.glassfish.grizzly.utils.JdkVersion;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;

public class SSLFilter
extends SSLBaseFilter {
    private static final Logger LOGGER = Grizzly.logger(SSLFilter.class);
    private static final boolean IS_JDK7_OR_HIGHER = JdkVersion.getJdkVersion().compareTo("1.7.0") >= 0;
    private final Attribute<SSLHandshakeContext> handshakeContextAttr;
    private final SSLEngineConfigurator clientSSLEngineConfigurator;
    private final ConnectionCloseListener closeListener = new ConnectionCloseListener();
    protected volatile int maxPendingBytes = Integer.MAX_VALUE;

    public SSLFilter() {
        this(null, null);
    }

    public SSLFilter(SSLEngineConfigurator serverSSLEngineConfigurator, SSLEngineConfigurator clientSSLEngineConfigurator) {
        this(serverSSLEngineConfigurator, clientSSLEngineConfigurator, true);
    }

    public SSLFilter(SSLEngineConfigurator serverSSLEngineConfigurator, SSLEngineConfigurator clientSSLEngineConfigurator, boolean renegotiateOnClientAuthWant) {
        super(serverSSLEngineConfigurator, renegotiateOnClientAuthWant);
        this.clientSSLEngineConfigurator = clientSSLEngineConfigurator == null ? new SSLEngineConfigurator(SSLContextConfigurator.DEFAULT_CONFIG.createSSLContext(), true, false, false) : clientSSLEngineConfigurator;
        this.handshakeContextAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("SSLFilter-SSLHandshakeContextAttr");
    }

    public SSLEngineConfigurator getClientSSLEngineConfigurator() {
        return this.clientSSLEngineConfigurator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        if (ctx.getMessage() instanceof FileTransfer) {
            throw new IllegalStateException("TLS operations not supported with SendFile messages");
        }
        Connection connection2 = connection;
        synchronized (connection2) {
            SSLConnectionContext sslCtx = this.obtainSslConnectionContext(connection);
            SSLEngine sslEngine = sslCtx.getSslEngine();
            if (sslEngine != null && !SSLUtils.isHandshaking(sslEngine)) {
                return sslCtx.isServerMode() ? super.handleWrite(ctx) : this.accurateWrite(ctx, true);
            }
            if (sslEngine == null || !this.handshakeContextAttr.isSet(connection)) {
                this.handshake(connection, null, null, this.clientSSLEngineConfigurator, ctx, false);
            }
            return this.accurateWrite(ctx, false);
        }
    }

    public int getMaxPendingBytesPerConnection() {
        return this.maxPendingBytes;
    }

    public void setMaxPendingBytesPerConnection(int maxPendingBytes) {
        this.maxPendingBytes = maxPendingBytes;
    }

    public void handshake(Connection connection, CompletionHandler<SSLEngine> completionHandler) throws IOException {
        this.handshake(connection, completionHandler, null, this.clientSSLEngineConfigurator);
    }

    public void handshake(Connection connection, CompletionHandler<SSLEngine> completionHandler, Object dstAddress) throws IOException {
        this.handshake(connection, completionHandler, dstAddress, this.clientSSLEngineConfigurator);
    }

    public void handshake(Connection connection, CompletionHandler<SSLEngine> completionHandler, Object dstAddress, SSLEngineConfigurator sslEngineConfigurator) throws IOException {
        this.handshake(connection, completionHandler, dstAddress, sslEngineConfigurator, this.createContext(connection, FilterChainContext.Operation.WRITE), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handshake(Connection<?> connection, CompletionHandler<SSLEngine> completionHandler, Object dstAddress, SSLEngineConfigurator sslEngineConfigurator, FilterChainContext context, boolean forceBeginHandshake) throws IOException {
        SSLConnectionContext sslCtx = this.obtainSslConnectionContext(connection);
        SSLEngine sslEngine = sslCtx.getSslEngine();
        if (sslEngine == null) {
            sslEngine = this.createClientSSLEngine(sslCtx, sslEngineConfigurator);
            sslCtx.configure(sslEngine);
        } else if (!SSLUtils.isHandshaking(sslEngine)) {
            sslEngineConfigurator.configure(sslEngine);
        }
        this.notifyHandshakeStart(connection);
        if (forceBeginHandshake || !sslEngine.getSession().isValid()) {
            sslEngine.beginHandshake();
        }
        this.handshakeContextAttr.set(connection, new SSLHandshakeContext(connection, completionHandler));
        connection.addCloseListener(this.closeListener);
        Connection<?> connection2 = connection;
        synchronized (connection2) {
            Buffer buffer = this.doHandshakeStep(sslCtx, context, null);
            assert (buffer == null);
        }
    }

    private NextAction accurateWrite(FilterChainContext ctx, boolean isHandshakeComplete) throws IOException {
        Connection connection = ctx.getConnection();
        SSLHandshakeContext handshakeContext = this.handshakeContextAttr.get(connection);
        if (isHandshakeComplete && handshakeContext == null) {
            return super.handleWrite(ctx);
        }
        if (handshakeContext == null) {
            handshakeContext = new SSLHandshakeContext(connection, null);
            this.handshakeContextAttr.set(connection, handshakeContext);
        }
        if (!handshakeContext.add(ctx)) {
            return super.handleWrite(ctx);
        }
        return ctx.getSuspendAction();
    }

    @Override
    protected void notifyHandshakeComplete(Connection<?> connection, SSLEngine sslEngine) {
        SSLHandshakeContext handshakeContext = this.handshakeContextAttr.get(connection);
        if (handshakeContext != null) {
            connection.removeCloseListener(this.closeListener);
            handshakeContext.completed(sslEngine);
            this.handshakeContextAttr.remove(connection);
        }
        super.notifyHandshakeComplete(connection, sslEngine);
    }

    @Override
    protected void notifyHandshakeFailed(Connection connection, Throwable t) {
        SSLHandshakeContext handshakeContext = this.handshakeContextAttr.get(connection);
        if (handshakeContext != null) {
            connection.removeCloseListener(this.closeListener);
            handshakeContext.failed(t);
        }
        super.notifyHandshakeFailed(connection, t);
    }

    @Override
    protected Buffer doHandshakeStep(SSLConnectionContext sslCtx, FilterChainContext ctx, Buffer inputBuffer, Buffer tmpAppBuffer0) throws IOException {
        try {
            return super.doHandshakeStep(sslCtx, ctx, inputBuffer, tmpAppBuffer0);
        }
        catch (IOException ioe) {
            SSLHandshakeContext context = this.handshakeContextAttr.get(ctx.getConnection());
            if (context != null) {
                context.failed(ioe);
            }
            throw ioe;
        }
    }

    protected SSLEngine createClientSSLEngine(SSLConnectionContext sslCtx, SSLEngineConfigurator sslEngineConfigurator) {
        return IS_JDK7_OR_HIGHER ? sslEngineConfigurator.createSSLEngine(HostNameResolver.getPeerHostName(sslCtx.getConnection()), -1) : sslEngineConfigurator.createSSLEngine();
    }

    private static class HostNameResolver {
        private HostNameResolver() {
        }

        public static String getPeerHostName(Connection<?> connection) {
            Object addr = connection.getPeerAddress();
            return addr instanceof InetSocketAddress ? ((InetSocketAddress)addr).getHostString() : null;
        }
    }

    private final class ConnectionCloseListener
    implements GenericCloseListener {
        private ConnectionCloseListener() {
        }

        @Override
        public void onClosed(Closeable closeable, CloseType type) throws IOException {
            Connection connection = (Connection)closeable;
            SSLHandshakeContext handshakeContext = (SSLHandshakeContext)SSLFilter.this.handshakeContextAttr.get(connection);
            if (handshakeContext != null) {
                handshakeContext.failed(new EOFException());
                SSLFilter.this.handshakeContextAttr.remove(connection);
            }
        }
    }

    private final class SSLHandshakeContext {
        private CompletionHandler<SSLEngine> completionHandler;
        private final Connection connection;
        private List<FilterChainContext> pendingWriteContexts;
        private int sizeInBytes = 0;
        private Throwable error;
        private boolean isComplete;

        public SSLHandshakeContext(Connection connection, CompletionHandler<SSLEngine> completionHandler) {
            this.connection = connection;
            this.completionHandler = completionHandler;
        }

        public boolean add(FilterChainContext context) throws IOException {
            if (this.error != null) {
                throw Exceptions.makeIOException(this.error);
            }
            if (this.isComplete) {
                return false;
            }
            Buffer buffer = (Buffer)context.getMessage();
            int newSize = this.sizeInBytes + buffer.remaining();
            if (newSize > SSLFilter.this.maxPendingBytes) {
                throw new PendingWriteQueueLimitExceededException("Max queued data limit exceeded: " + newSize + '>' + SSLFilter.this.maxPendingBytes);
            }
            this.sizeInBytes = newSize;
            if (this.pendingWriteContexts == null) {
                this.pendingWriteContexts = new LinkedList<FilterChainContext>();
            }
            this.pendingWriteContexts.add(context);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed(SSLEngine engine) {
            try {
                Connection connection = this.connection;
                synchronized (connection) {
                    this.isComplete = true;
                    CompletionHandler<SSLEngine> completionHandlerLocal = this.completionHandler;
                    this.completionHandler = null;
                    if (completionHandlerLocal != null) {
                        completionHandlerLocal.completed(engine);
                    }
                    this.resumePendingWrites();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Unexpected SSLHandshakeContext.completed() error", e);
                this.failed(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failed(Throwable throwable) {
            Connection connection = this.connection;
            synchronized (connection) {
                if (this.error != null) {
                    return;
                }
                this.error = throwable;
                CompletionHandler<SSLEngine> completionHandlerLocal = this.completionHandler;
                this.completionHandler = null;
                if (completionHandlerLocal != null) {
                    completionHandlerLocal.failed(throwable);
                }
                this.connection.closeWithReason(Exceptions.makeIOException(throwable));
                this.resumePendingWrites();
            }
        }

        private void resumePendingWrites() {
            List<FilterChainContext> pendingWriteContextsLocal = this.pendingWriteContexts;
            this.pendingWriteContexts = null;
            if (pendingWriteContextsLocal != null) {
                for (FilterChainContext ctx : pendingWriteContextsLocal) {
                    try {
                        ctx.resume();
                    }
                    catch (Exception e) {}
                }
                pendingWriteContextsLocal.clear();
                this.sizeInBytes = 0;
            }
        }
    }
}

