/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.strategies;

import com.pdd.pop.ext.glassfish.grizzly.Connection;
import com.pdd.pop.ext.glassfish.grizzly.Grizzly;
import com.pdd.pop.ext.glassfish.grizzly.IOEvent;
import com.pdd.pop.ext.glassfish.grizzly.IOEventLifeCycleListener;
import com.pdd.pop.ext.glassfish.grizzly.nio.NIOConnection;
import com.pdd.pop.ext.glassfish.grizzly.nio.SelectorRunner;
import com.pdd.pop.ext.glassfish.grizzly.strategies.AbstractIOStrategy;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.logging.Logger;

public final class LeaderFollowerNIOStrategy
extends AbstractIOStrategy {
    private static final LeaderFollowerNIOStrategy INSTANCE = new LeaderFollowerNIOStrategy();
    private static final Logger logger = Grizzly.logger(LeaderFollowerNIOStrategy.class);

    private LeaderFollowerNIOStrategy() {
    }

    public static LeaderFollowerNIOStrategy getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean executeIoEvent(Connection connection, IOEvent ioEvent, boolean isIoEventEnabled) throws IOException {
        Executor threadPool;
        NIOConnection nioConnection = (NIOConnection)connection;
        IOEventLifeCycleListener listener = null;
        if (LeaderFollowerNIOStrategy.isReadWrite(ioEvent)) {
            if (isIoEventEnabled) {
                connection.disableIOEvent(ioEvent);
            }
            listener = ENABLE_INTEREST_LIFECYCLE_LISTENER;
        }
        if ((threadPool = this.getThreadPoolFor(connection, ioEvent)) != null) {
            SelectorRunner runner = nioConnection.getSelectorRunner();
            runner.postpone();
            threadPool.execute(runner);
            LeaderFollowerNIOStrategy.fireIOEvent(connection, ioEvent, listener, logger);
            return false;
        }
        LeaderFollowerNIOStrategy.fireIOEvent(connection, ioEvent, listener, logger);
        return true;
    }
}

