/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.strategies;

import com.pdd.pop.ext.glassfish.grizzly.Connection;
import com.pdd.pop.ext.glassfish.grizzly.Grizzly;
import com.pdd.pop.ext.glassfish.grizzly.IOEvent;
import com.pdd.pop.ext.glassfish.grizzly.IOEventLifeCycleListener;
import com.pdd.pop.ext.glassfish.grizzly.strategies.AbstractIOStrategy;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.logging.Logger;

public final class WorkerThreadIOStrategy
extends AbstractIOStrategy {
    private static final WorkerThreadIOStrategy INSTANCE = new WorkerThreadIOStrategy();
    private static final Logger logger = Grizzly.logger(WorkerThreadIOStrategy.class);

    private WorkerThreadIOStrategy() {
    }

    public static WorkerThreadIOStrategy getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean executeIoEvent(Connection connection, IOEvent ioEvent, boolean isIoEventEnabled) throws IOException {
        IOEventLifeCycleListener listener;
        boolean isReadOrWriteEvent = WorkerThreadIOStrategy.isReadWrite(ioEvent);
        if (isReadOrWriteEvent) {
            if (isIoEventEnabled) {
                connection.disableIOEvent(ioEvent);
            }
            listener = ENABLE_INTEREST_LIFECYCLE_LISTENER;
        } else {
            listener = null;
        }
        Executor threadPool = this.getThreadPoolFor(connection, ioEvent);
        if (threadPool != null) {
            threadPool.execute(new WorkerThreadRunnable(connection, ioEvent, listener));
        } else {
            WorkerThreadIOStrategy.run0(connection, ioEvent, listener);
        }
        return true;
    }

    private static void run0(Connection connection, IOEvent ioEvent, IOEventLifeCycleListener lifeCycleListener) {
        WorkerThreadIOStrategy.fireIOEvent(connection, ioEvent, lifeCycleListener, logger);
    }

    private static final class WorkerThreadRunnable
    implements Runnable {
        final Connection connection;
        final IOEvent ioEvent;
        final IOEventLifeCycleListener lifeCycleListener;

        private WorkerThreadRunnable(Connection connection, IOEvent ioEvent, IOEventLifeCycleListener lifeCycleListener) {
            this.connection = connection;
            this.ioEvent = ioEvent;
            this.lifeCycleListener = lifeCycleListener;
        }

        @Override
        public void run() {
            WorkerThreadIOStrategy.run0(this.connection, this.ioEvent, this.lifeCycleListener);
        }
    }
}

