/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.streams;

import com.pdd.pop.ext.glassfish.grizzly.TransformationException;
import com.pdd.pop.ext.glassfish.grizzly.TransformationResult;
import com.pdd.pop.ext.glassfish.grizzly.Transformer;
import com.pdd.pop.ext.glassfish.grizzly.streams.Stream;
import com.pdd.pop.ext.glassfish.grizzly.streams.StreamReader;
import com.pdd.pop.ext.glassfish.grizzly.utils.ResultAware;
import com.pdd.pop.ext.glassfish.grizzly.utils.conditions.Condition;

public class StreamDecodeCondition<E>
implements Condition {
    private final StreamReader streamReader;
    private final Transformer<Stream, E> decoder;
    private final ResultAware<E> resultAware;

    public StreamDecodeCondition(StreamReader streamReader, Transformer<Stream, E> decoder, ResultAware<E> resultAware) {
        this.streamReader = streamReader;
        this.decoder = decoder;
        this.resultAware = resultAware;
    }

    @Override
    public boolean check() {
        TransformationResult<Stream, E> result = this.decoder.transform(this.streamReader.getConnection(), this.streamReader);
        TransformationResult.Status status = result.getStatus();
        if (status == TransformationResult.Status.COMPLETE) {
            this.resultAware.setResult(result.getMessage());
            return true;
        }
        if (status == TransformationResult.Status.INCOMPLETE) {
            return false;
        }
        throw new TransformationException(result.getErrorCode() + ": " + result.getErrorDescription());
    }
}

