/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.streams;

import com.pdd.pop.ext.glassfish.grizzly.Buffer;
import com.pdd.pop.ext.glassfish.grizzly.Connection;
import com.pdd.pop.ext.glassfish.grizzly.EmptyCompletionHandler;
import com.pdd.pop.ext.glassfish.grizzly.Grizzly;
import com.pdd.pop.ext.glassfish.grizzly.TransformationException;
import com.pdd.pop.ext.glassfish.grizzly.TransformationResult;
import com.pdd.pop.ext.glassfish.grizzly.Transformer;
import com.pdd.pop.ext.glassfish.grizzly.attributes.Attribute;
import com.pdd.pop.ext.glassfish.grizzly.attributes.AttributeStorage;
import com.pdd.pop.ext.glassfish.grizzly.memory.CompositeBuffer;
import com.pdd.pop.ext.glassfish.grizzly.memory.MemoryManager;
import com.pdd.pop.ext.glassfish.grizzly.streams.BufferedInput;
import com.pdd.pop.ext.glassfish.grizzly.streams.Input;
import com.pdd.pop.ext.glassfish.grizzly.utils.conditions.Condition;
import java.io.IOException;

public final class TransformerInput
extends BufferedInput {
    private final Attribute<CompositeBuffer> inputBufferAttr;
    protected final Transformer<Buffer, Buffer> transformer;
    protected final Input underlyingInput;
    protected final MemoryManager memoryManager;
    protected final AttributeStorage attributeStorage;

    public TransformerInput(Transformer<Buffer, Buffer> transformer, Input underlyingInput, Connection connection) {
        this(transformer, underlyingInput, connection.getMemoryManager(), connection);
    }

    public TransformerInput(Transformer<Buffer, Buffer> transformer, Input underlyingInput, MemoryManager memoryManager, AttributeStorage attributeStorage) {
        this.transformer = transformer;
        this.underlyingInput = underlyingInput;
        this.memoryManager = memoryManager;
        this.attributeStorage = attributeStorage;
        this.inputBufferAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("TransformerInput-" + transformer.getName());
    }

    @Override
    protected void onOpenInputSource() throws IOException {
        this.underlyingInput.notifyCondition(new TransformerCondition(), new TransformerCompletionHandler());
    }

    @Override
    protected void onCloseInputSource() throws IOException {
    }

    public final class TransformerCondition
    implements Condition {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean check() {
            try {
                Buffer chunkBuffer;
                boolean hasSavedBuffer;
                CompositeBuffer savedBuffer = (CompositeBuffer)TransformerInput.this.inputBufferAttr.get(TransformerInput.this.attributeStorage);
                Buffer bufferToTransform = savedBuffer;
                boolean bl = hasSavedBuffer = savedBuffer != null;
                if (TransformerInput.this.underlyingInput.isBuffered()) {
                    chunkBuffer = TransformerInput.this.underlyingInput.takeBuffer();
                } else {
                    int size = TransformerInput.this.underlyingInput.size();
                    chunkBuffer = TransformerInput.this.memoryManager.allocate(size);
                    while (size-- >= 0) {
                        chunkBuffer.put(TransformerInput.this.underlyingInput.read());
                    }
                    chunkBuffer.flip();
                }
                if (hasSavedBuffer) {
                    savedBuffer.append(chunkBuffer);
                } else {
                    bufferToTransform = chunkBuffer;
                }
                while (bufferToTransform.hasRemaining()) {
                    TransformationResult<Buffer, Buffer> result = TransformerInput.this.transformer.transform(TransformerInput.this.attributeStorage, bufferToTransform);
                    TransformationResult.Status status = result.getStatus();
                    if (status == TransformationResult.Status.COMPLETE) {
                        Buffer outputBuffer = result.getMessage();
                        TransformerInput.this.lock.writeLock().lock();
                        try {
                            TransformerInput.this.append(outputBuffer);
                            if (TransformerInput.this.isCompletionHandlerRegistered) continue;
                            boolean bl2 = true;
                            return bl2;
                        }
                        finally {
                            TransformerInput.this.lock.writeLock().unlock();
                            continue;
                        }
                    }
                    if (status == TransformationResult.Status.INCOMPLETE) {
                        if (hasSavedBuffer) return false;
                        if (bufferToTransform.isComposite()) {
                            TransformerInput.this.inputBufferAttr.set(TransformerInput.this.attributeStorage, (CompositeBuffer)bufferToTransform);
                            return false;
                        }
                        savedBuffer = CompositeBuffer.newBuffer(TransformerInput.this.memoryManager);
                        savedBuffer.append(bufferToTransform);
                        TransformerInput.this.inputBufferAttr.set(TransformerInput.this.attributeStorage, savedBuffer);
                        return false;
                    }
                    if (status == TransformationResult.Status.ERROR) throw new TransformationException(result.getErrorDescription());
                }
                return false;
            }
            catch (IOException e) {
                throw new TransformationException(e);
            }
        }
    }

    public final class TransformerCompletionHandler
    extends EmptyCompletionHandler<Integer> {
        @Override
        public void failed(Throwable throwable) {
            TransformerInput.this.notifyFailure(TransformerInput.this.completionHandler, throwable);
            TransformerInput.this.future.failure(throwable);
        }
    }
}

