/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.threadpool;

import com.pdd.pop.ext.glassfish.grizzly.ThreadCache;
import com.pdd.pop.ext.glassfish.grizzly.attributes.AttributeBuilder;
import com.pdd.pop.ext.glassfish.grizzly.attributes.AttributeHolder;
import com.pdd.pop.ext.glassfish.grizzly.memory.ThreadLocalPool;
import com.pdd.pop.ext.glassfish.grizzly.threadpool.WorkerThread;
import java.util.concurrent.TimeUnit;

public class DefaultWorkerThread
extends Thread
implements WorkerThread {
    private final AttributeHolder attributes;
    private final ThreadLocalPool memoryPool;
    private final ThreadCache.ObjectCache objectCache = new ThreadCache.ObjectCache();
    private long transactionTimeoutMillis = -1L;

    public DefaultWorkerThread(AttributeBuilder attrBuilder, String name, ThreadLocalPool pool, Runnable runTask) {
        super(runTask, name);
        this.attributes = attrBuilder.createUnsafeAttributeHolder();
        this.memoryPool = pool;
    }

    @Override
    public Thread getThread() {
        return this;
    }

    @Override
    public AttributeHolder getAttributes() {
        return this.attributes;
    }

    public ThreadLocalPool getMemoryPool() {
        return this.memoryPool;
    }

    public final <E> E getFromCache(ThreadCache.CachedTypeIndex<E> index) {
        return this.objectCache.get(index);
    }

    public final <E> E takeFromCache(ThreadCache.CachedTypeIndex<E> index) {
        return this.objectCache.take(index);
    }

    public final <E> boolean putToCache(ThreadCache.CachedTypeIndex<E> index, E o) {
        return this.objectCache.put(index, o);
    }

    @Override
    public long getTransactionTimeout(TimeUnit timeunit) {
        return timeunit.convert(this.transactionTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setTransactionTimeout(long timeout, TimeUnit timeunit) {
        this.transactionTimeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeunit);
    }
}

