/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.threadpool;

import com.pdd.pop.ext.glassfish.grizzly.threadpool.AbstractThreadPool;
import com.pdd.pop.ext.glassfish.grizzly.threadpool.FixedThreadPool;
import com.pdd.pop.ext.glassfish.grizzly.threadpool.ThreadPoolConfig;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;

final class QueueLimitedThreadPool
extends FixedThreadPool {
    private final Semaphore queuePermits;

    QueueLimitedThreadPool(ThreadPoolConfig config) {
        super(config);
        if (config.getQueueLimit() < 0) {
            throw new IllegalArgumentException("maxQueuedTasks < 0");
        }
        this.queuePermits = new Semaphore(config.getQueueLimit());
    }

    @Override
    public final void execute(Runnable command) {
        if (command == null) {
            throw new IllegalArgumentException("Runnable task is null");
        }
        if (!this.running) {
            throw new RejectedExecutionException("ThreadPool is not running");
        }
        if (!this.queuePermits.tryAcquire()) {
            this.onTaskQueueOverflow();
        }
        if (!this.workQueue.offer(command)) {
            this.queuePermits.release();
            this.onTaskQueueOverflow();
        }
        this.onTaskQueued(command);
    }

    @Override
    protected final void beforeExecute(AbstractThreadPool.Worker worker, Thread t, Runnable r) {
        super.beforeExecute(worker, t, r);
        this.queuePermits.release();
    }
}

