/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.utils;

import com.pdd.pop.ext.glassfish.grizzly.AbstractTransformer;
import com.pdd.pop.ext.glassfish.grizzly.Buffer;
import com.pdd.pop.ext.glassfish.grizzly.Grizzly;
import com.pdd.pop.ext.glassfish.grizzly.TransformationException;
import com.pdd.pop.ext.glassfish.grizzly.TransformationResult;
import com.pdd.pop.ext.glassfish.grizzly.attributes.AttributeStorage;
import com.pdd.pop.ext.glassfish.grizzly.filterchain.AbstractCodecFilter;
import com.pdd.pop.ext.glassfish.grizzly.memory.Buffers;
import java.util.logging.Logger;

public class ChunkingFilter
extends AbstractCodecFilter<Buffer, Buffer> {
    private static final Logger LOGGER = Grizzly.logger(ChunkingFilter.class);
    private final int chunkSize;

    public ChunkingFilter(int chunkSize) {
        super(new ChunkingDecoder(chunkSize), new ChunkingEncoder(chunkSize));
        this.chunkSize = chunkSize;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public static abstract class ChunkingTransformer
    extends AbstractTransformer<Buffer, Buffer> {
        private final int chunk;

        public ChunkingTransformer(int chunk) {
            this.chunk = chunk;
        }

        @Override
        public String getName() {
            return "ChunkingTransformer";
        }

        @Override
        protected TransformationResult<Buffer, Buffer> transformImpl(AttributeStorage storage, Buffer input) throws TransformationException {
            if (!input.hasRemaining()) {
                return TransformationResult.createIncompletedResult(input);
            }
            int chunkSize = Math.min(this.chunk, input.remaining());
            int oldInputPos = input.position();
            int oldInputLimit = input.limit();
            Buffers.setPositionLimit(input, oldInputPos, oldInputPos + chunkSize);
            Object output = this.obtainMemoryManager(storage).allocate(chunkSize);
            output.put(input).flip();
            Buffers.setPositionLimit(input, oldInputPos + chunkSize, oldInputLimit);
            return TransformationResult.createCompletedResult(output, input);
        }

        @Override
        public boolean hasInputRemaining(AttributeStorage storage, Buffer input) {
            return input != null && input.hasRemaining();
        }
    }

    public static final class ChunkingEncoder
    extends ChunkingTransformer {
        public ChunkingEncoder(int chunk) {
            super(chunk);
        }
    }

    public static final class ChunkingDecoder
    extends ChunkingTransformer {
        public ChunkingDecoder(int chunk) {
            super(chunk);
        }
    }
}

