/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.utils;

import com.pdd.pop.ext.glassfish.grizzly.CompletionHandler;
import com.pdd.pop.ext.glassfish.grizzly.impl.FutureImpl;
import com.pdd.pop.ext.glassfish.grizzly.utils.GenericAdapter;

public class CompletionHandlerAdapter<A, B>
implements CompletionHandler<B> {
    private static final GenericAdapter DIRECT_ADAPTER = new GenericAdapter(){

        public Object adapt(Object result) {
            return result;
        }
    };
    private final GenericAdapter<B, A> adapter;
    private final FutureImpl<A> future;
    private final CompletionHandler<A> completionHandler;

    public CompletionHandlerAdapter(FutureImpl<A> future) {
        this(future, null);
    }

    public CompletionHandlerAdapter(FutureImpl<A> future, CompletionHandler<A> completionHandler) {
        this(future, completionHandler, null);
    }

    public CompletionHandlerAdapter(FutureImpl<A> future, CompletionHandler<A> completionHandler, GenericAdapter<B, A> adapter) {
        this.future = future;
        this.completionHandler = completionHandler;
        this.adapter = adapter != null ? adapter : CompletionHandlerAdapter.getDirectAdapter();
    }

    @Override
    public void cancelled() {
        if (this.completionHandler != null) {
            this.completionHandler.cancelled();
        }
        if (this.future != null) {
            this.future.cancel(false);
        }
    }

    @Override
    public void failed(Throwable throwable) {
        if (this.completionHandler != null) {
            this.completionHandler.failed(throwable);
        }
        if (this.future != null) {
            this.future.failure(throwable);
        }
    }

    @Override
    public void completed(B result) {
        A adaptedResult = this.adapt(result);
        if (this.completionHandler != null) {
            this.completionHandler.completed(adaptedResult);
        }
        if (this.future != null) {
            this.future.result(adaptedResult);
        }
    }

    @Override
    public void updated(B result) {
        A adaptedResult = this.adapt(result);
        if (this.completionHandler != null) {
            this.completionHandler.updated(adaptedResult);
        }
    }

    protected A adapt(B result) {
        return this.adapter.adapt(result);
    }

    private static <K, V> GenericAdapter<K, V> getDirectAdapter() {
        return DIRECT_ADAPTER;
    }
}

