/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.grizzly.utils;

import com.pdd.pop.ext.glassfish.grizzly.Grizzly;
import com.pdd.pop.ext.glassfish.grizzly.utils.ConcurrentHashMapV8;
import com.pdd.pop.ext.glassfish.grizzly.utils.JdkVersion;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;

public class DataStructures {
    private static final boolean USE_CUSTOM_CHM8;
    private static final Class<?> LTQclass;

    private static Class<?> getAndVerify(String cname) throws Throwable {
        return DataStructures.class.getClassLoader().loadClass(cname).newInstance().getClass();
    }

    public static <T> BlockingQueue<T> getLTQInstance() {
        try {
            return (BlockingQueue)LTQclass.newInstance();
        }
        catch (Exception ea) {
            throw new RuntimeException(ea);
        }
    }

    public static <T> BlockingQueue<T> getLTQInstance(Class<T> t) {
        try {
            return (BlockingQueue)LTQclass.newInstance();
        }
        catch (Exception ea) {
            throw new RuntimeException(ea);
        }
    }

    public static <K, V> ConcurrentMap<K, V> getConcurrentMap() {
        return (ConcurrentMap)((Object)(USE_CUSTOM_CHM8 ? new ConcurrentHashMapV8() : new ConcurrentHashMap()));
    }

    public static <K, V> ConcurrentMap<K, V> getConcurrentMap(Map<? extends K, ? extends V> map) {
        return (ConcurrentMap)((Object)(USE_CUSTOM_CHM8 ? new ConcurrentHashMapV8<K, V>(map) : new ConcurrentHashMap<K, V>(map)));
    }

    public static <K, V> ConcurrentMap<K, V> getConcurrentMap(int initialCapacity) {
        return (ConcurrentMap)((Object)(USE_CUSTOM_CHM8 ? new ConcurrentHashMapV8(initialCapacity) : new ConcurrentHashMap(initialCapacity)));
    }

    public static <K, V> ConcurrentMap<K, V> getConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return (ConcurrentMap)((Object)(USE_CUSTOM_CHM8 ? new ConcurrentHashMapV8(initialCapacity, loadFactor, concurrencyLevel) : new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel)));
    }

    static {
        Class c;
        String className = null;
        boolean useCustomCHM8 = false;
        try {
            JdkVersion jdkVersion = JdkVersion.getJdkVersion();
            JdkVersion jdk18Version = JdkVersion.parseVersion("1.8.0");
            useCustomCHM8 = jdkVersion.isUnsafeSupported() && jdk18Version.compareTo(jdkVersion) > 0;
            JdkVersion jdk17Version = JdkVersion.parseVersion("1.7.0");
            className = jdk17Version.compareTo(jdkVersion) <= 0 ? "java.util.concurrent.LinkedTransferQueue" : "com.pdd.pop.ext.glassfish.grizzly.utils.LinkedTransferQueue";
            c = DataStructures.getAndVerify(className);
            Grizzly.logger(DataStructures.class).log(Level.FINE, "USING LTQ class:{0}", c);
        }
        catch (Throwable t) {
            Grizzly.logger(DataStructures.class).log(Level.FINE, "failed loading datastructure class:" + className + " fallback to embedded one", t);
            c = LinkedBlockingQueue.class;
        }
        LTQclass = c;
        USE_CUSTOM_CHM8 = useCustomCHM8;
    }
}

