/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.tyrus.container.grizzly.client;

import com.pdd.pop.ext.glassfish.grizzly.Buffer;
import com.pdd.pop.ext.glassfish.grizzly.Connection;
import com.pdd.pop.ext.glassfish.grizzly.EmptyCompletionHandler;
import com.pdd.pop.ext.glassfish.grizzly.WriteHandler;
import com.pdd.pop.ext.glassfish.grizzly.memory.Buffers;
import com.pdd.pop.ext.glassfish.tyrus.container.grizzly.client.TaskProcessor;
import com.pdd.pop.ext.glassfish.tyrus.spi.CompletionHandler;
import com.pdd.pop.ext.glassfish.tyrus.spi.Writer;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GrizzlyWriter
extends Writer {
    private final TaskProcessor taskProcessor;
    final Connection connection;

    public GrizzlyWriter(Connection connection) {
        this.connection = connection;
        this.connection.configureBlocking(false);
        this.taskProcessor = new TaskProcessor(new WriterCondition());
    }

    @Override
    public void write(final ByteBuffer buffer, final CompletionHandler<ByteBuffer> completionHandler) {
        if (!this.connection.isOpen()) {
            completionHandler.failed(new IllegalStateException("Connection is not open."));
            return;
        }
        Buffer message = Buffers.wrap(this.connection.getTransport().getMemoryManager(), buffer);
        EmptyCompletionHandler emptyCompletionHandler = new EmptyCompletionHandler(){

            @Override
            public void cancelled() {
                if (completionHandler != null) {
                    completionHandler.cancelled();
                }
            }

            @Override
            public void completed(Object result) {
                if (completionHandler != null) {
                    completionHandler.completed(buffer);
                }
            }

            @Override
            public void failed(Throwable throwable) {
                if (completionHandler != null) {
                    completionHandler.failed(throwable);
                }
            }
        };
        this.taskProcessor.processTask(new WriteTask(this.connection, message, emptyCompletionHandler));
    }

    @Override
    public void close() {
        this.taskProcessor.processTask(new CloseTask(this.connection));
    }

    public int hashCode() {
        return this.connection.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof GrizzlyWriter && this.connection.equals(((GrizzlyWriter)obj).connection);
    }

    public String toString() {
        return this.getClass().getName() + " " + this.connection.toString() + " " + this.connection.hashCode();
    }

    private class CloseTask
    extends TaskProcessor.Task {
        private final Connection connection;

        private CloseTask(Connection connection) {
            this.connection = connection;
        }

        @Override
        public void execute() {
            this.connection.closeSilently();
        }
    }

    private class WriteTask
    extends TaskProcessor.Task {
        private final Connection connection;
        private final Buffer message;
        private final EmptyCompletionHandler completionHandler;

        private WriteTask(Connection connection, Buffer message, EmptyCompletionHandler completionHandler) {
            this.connection = connection;
            this.message = message;
            this.completionHandler = completionHandler;
        }

        @Override
        public void execute() {
            this.connection.write(this.message, this.completionHandler);
        }
    }

    private class WriterCondition
    implements TaskProcessor.Condition {
        private final AtomicBoolean writeHandlerRegistered = new AtomicBoolean(false);

        private WriterCondition() {
        }

        @Override
        public boolean isValid() {
            if (!GrizzlyWriter.this.connection.canWrite() && this.writeHandlerRegistered.compareAndSet(false, true)) {
                GrizzlyWriter.this.connection.notifyCanWrite(new WriteHandler(){

                    @Override
                    public void onWritePossible() throws Exception {
                        WriterCondition.this.writeHandlerRegistered.set(false);
                        GrizzlyWriter.this.taskProcessor.processTask();
                    }

                    @Override
                    public void onError(Throwable t) {
                        WriterCondition.this.writeHandlerRegistered.set(false);
                        Logger.getLogger(GrizzlyWriter.class.getName()).log(Level.WARNING, t.getMessage(), t);
                    }
                });
                return false;
            }
            return true;
        }
    }
}

