/*
 * Decompiled with CFR 0.152.
 */
package com.pdd.pop.ext.glassfish.tyrus.core;

import com.pdd.pop.ext.glassfish.tyrus.core.BufferedStringReader;
import com.pdd.pop.ext.glassfish.tyrus.core.MessageTooBigException;
import com.pdd.pop.ext.glassfish.tyrus.core.l10n.LocalizationMessages;
import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.MessageHandler;

class ReaderBuffer {
    private final AtomicBoolean buffering = new AtomicBoolean(true);
    private final ExecutorService executorService;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private static final Logger LOGGER = Logger.getLogger(ReaderBuffer.class.getName());
    private volatile boolean receivedLast = false;
    private volatile int bufferSize;
    private volatile int currentlyBuffered;
    private volatile StringBuffer buffer = new StringBuffer();
    private volatile BufferedStringReader reader = null;
    private volatile MessageHandler.Whole<Reader> messageHandler;
    private volatile boolean sessionClosed = false;

    public ReaderBuffer(ExecutorService executorService) {
        this.executorService = executorService;
        this.currentlyBuffered = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getNextChars(int number) throws IOException {
        this.lock.lock();
        try {
            if (this.buffer.length() == 0) {
                boolean interrupted;
                if (this.receivedLast) {
                    this.reader = null;
                    this.buffering.set(true);
                    this.currentlyBuffered = 0;
                    char[] cArray = null;
                    return cArray;
                }
                this.checkClosedSession();
                do {
                    interrupted = false;
                    try {
                        this.condition.await();
                        this.checkClosedSession();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                } while (interrupted);
            }
            int size = number > this.buffer.length() ? this.buffer.length() : number;
            char[] result = new char[size];
            this.buffer.getChars(0, size, result, 0);
            this.buffer.delete(0, size);
            char[] cArray = result;
            return cArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void finishReading() {
        this.buffer = new StringBuffer();
        this.reader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendMessagePart(String message, boolean last) {
        this.lock.lock();
        try {
            this.currentlyBuffered += message.length();
            if (this.currentlyBuffered <= this.bufferSize) {
                this.buffer.append(message);
            } else if (this.buffering.get()) {
                this.buffering.set(false);
                MessageTooBigException messageTooBigException = new MessageTooBigException(LocalizationMessages.PARTIAL_MESSAGE_BUFFER_OVERFLOW());
                LOGGER.log(Level.FINE, LocalizationMessages.PARTIAL_MESSAGE_BUFFER_OVERFLOW(), messageTooBigException);
                this.receivedLast = true;
                throw messageTooBigException;
            }
            this.receivedLast = last;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        if (this.reader == null) {
            this.reader = new BufferedStringReader(this);
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    ReaderBuffer.this.messageHandler.onMessage(ReaderBuffer.this.reader);
                }
            });
        }
    }

    public void setMessageHandler(MessageHandler.Whole<Reader> messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void resetBuffer(int bufferSize) {
        this.bufferSize = bufferSize;
        this.buffering.set(true);
        this.currentlyBuffered = 0;
        this.buffer.delete(0, this.buffer.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSessionClosed() {
        this.sessionClosed = true;
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkClosedSession() throws IOException {
        if (this.sessionClosed) {
            throw new IOException("Websocket session has been closed.");
        }
    }
}

